/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.GroovySourceSet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.javadoc.Groovydoc;

public class GroovyPlugin
implements Plugin<Project> {
    public static final String GROOVYDOC_TASK_NAME = "groovydoc";

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(GroovyBasePlugin.class);
        project.getPluginManager().apply(JavaPlugin.class);
        this.configureGroovydoc(project);
    }

    private void configureGroovydoc(final Project project) {
        project.getTasks().createLater(GROOVYDOC_TASK_NAME, Groovydoc.class, new Action<Groovydoc>(){

            @Override
            public void execute(Groovydoc groovyDoc) {
                groovyDoc.setDescription("Generates Groovydoc API documentation for the main source code.");
                groovyDoc.setGroup("documentation");
                JavaPluginConvention convention = project.getConvention().getPlugin(JavaPluginConvention.class);
                SourceSet sourceSet = (SourceSet)convention.getSourceSets().getByName("main");
                groovyDoc.setClasspath(sourceSet.getOutput().plus(sourceSet.getCompileClasspath()));
                GroovySourceSet groovySourceSet = new DslObject(sourceSet).getConvention().getPlugin(GroovySourceSet.class);
                groovyDoc.setSource(groovySourceSet.getGroovy());
            }
        });
    }
}

