/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.PropertySpecFactory;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidationAction;
import org.gradle.api.internal.tasks.properties.BeanPropertyContext;
import org.gradle.api.internal.tasks.properties.PropertyMetadata;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyValueVisitor;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.TypeMetadata;
import org.gradle.api.internal.tasks.properties.bean.RuntimeBeanNode;
import org.gradle.api.internal.tasks.properties.bean.RuntimeBeanNodeFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Optional;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.base.Supplier;
import org.gradle.internal.impldep.com.google.common.base.Suppliers;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.util.DeferredUtil;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNestedRuntimeBeanNode
extends RuntimeBeanNode<Object> {
    protected AbstractNestedRuntimeBeanNode(@Nullable RuntimeBeanNode<?> parentNode, @Nullable String propertyName, Object bean, TypeMetadata typeMetadata) {
        super(parentNode, propertyName, bean, typeMetadata);
    }

    public void visitProperties(PropertyVisitor visitor, PropertySpecFactory specFactory, final Queue<RuntimeBeanNode<?>> queue, final RuntimeBeanNodeFactory nodeFactory) {
        TypeMetadata typeMetadata = this.getTypeMetadata();
        for (PropertyMetadata propertyMetadata : typeMetadata.getPropertiesMetadata()) {
            PropertyValueVisitor propertyValueVisitor = propertyMetadata.getPropertyValueVisitor();
            if (propertyValueVisitor == null) continue;
            String propertyName = this.getQualifiedPropertyName(propertyMetadata.getFieldName());
            DefaultPropertyValue propertyValue = new DefaultPropertyValue(propertyName, propertyMetadata.getAnnotations(), this.getBean(), propertyMetadata.getMethod());
            propertyValueVisitor.visitPropertyValue(propertyValue, visitor, specFactory, new BeanPropertyContext(){

                public void addNested(String propertyName, Object bean) {
                    queue.add(nodeFactory.create(AbstractNestedRuntimeBeanNode.this, propertyName, bean));
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultPropertyValue
    implements PropertyValue {
        private final String propertyName;
        private final List<Annotation> annotations;
        private final Object bean;
        private final Method method;
        private final Supplier<Object> valueSupplier = Suppliers.memoize((Supplier)new Supplier<Object>(){

            @Nullable
            public Object get() {
                Object value = DeprecationLogger.whileDisabled(new Factory<Object>(){

                    @Override
                    public Object create() {
                        try {
                            return DefaultPropertyValue.this.method.invoke(DefaultPropertyValue.this.bean, new Object[0]);
                        }
                        catch (InvocationTargetException e) {
                            throw UncheckedException.throwAsUncheckedException(e.getCause());
                        }
                        catch (Exception e) {
                            throw new GradleException(String.format("Could not call %s.%s() on %s", DefaultPropertyValue.this.method.getDeclaringClass().getSimpleName(), DefaultPropertyValue.this.method.getName(), DefaultPropertyValue.this.bean), e);
                        }
                    }
                });
                if (value instanceof Provider && !((Provider)value).isPresent()) {
                    return null;
                }
                return value;
            }
        });

        public DefaultPropertyValue(String propertyName, List<Annotation> annotations, Object bean, Method method) {
            this.propertyName = propertyName;
            this.annotations = ImmutableList.copyOf(annotations);
            this.bean = bean;
            this.method = method;
            method.setAccessible(true);
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.getAnnotation(annotationType) != null;
        }

        @Override
        @Nullable
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            for (Annotation annotation : this.annotations) {
                if (!annotationType.equals(annotation.annotationType())) continue;
                return (A)((Annotation)annotationType.cast(annotation));
            }
            return null;
        }

        @Override
        public boolean isOptional() {
            return this.isAnnotationPresent(Optional.class);
        }

        @Override
        @Nullable
        public Object getValue() {
            return this.valueSupplier.get();
        }

        @Override
        @Nullable
        public Object call() {
            return this.getValue();
        }

        @Override
        public void validate(String propertyName, boolean optional, ValidationAction valueValidator, TaskValidationContext context) {
            Object unpacked = DeferredUtil.unpack(this.getValue());
            if (unpacked == null) {
                if (!optional) {
                    context.recordValidationMessage(TaskValidationContext.Severity.ERROR, String.format("No value has been specified for property '%s'.", propertyName));
                }
            } else {
                valueValidator.validate(propertyName, unpacked, context, TaskValidationContext.Severity.ERROR);
            }
        }
    }
}

