/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.properties.TypeMetadata;
import org.gradle.internal.impldep.com.google.common.base.Equivalence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyNode<T> {
    private final String propertyName;
    private final AbstractPropertyNode<T> parentNode;
    private final TypeMetadata typeMetadata;

    public AbstractPropertyNode(@Nullable AbstractPropertyNode<T> parentNode, @Nullable String propertyName, TypeMetadata typeMetadata) {
        this.propertyName = propertyName;
        this.parentNode = parentNode;
        this.typeMetadata = typeMetadata;
    }

    protected String getQualifiedPropertyName(String childPropertyName) {
        return this.propertyName == null ? childPropertyName : this.propertyName + "." + childPropertyName;
    }

    @Nullable
    public String getPropertyName() {
        return this.propertyName;
    }

    public TypeMetadata getTypeMetadata() {
        return this.typeMetadata;
    }

    @Nullable
    protected AbstractPropertyNode<T> findNodeCreatingCycle(T childValue, Equivalence<? super T> nodeEquivalence) {
        if (nodeEquivalence.equivalent(this.getNodeValue(), childValue)) {
            return this;
        }
        if (this.parentNode == null) {
            return null;
        }
        return this.parentNode.findNodeCreatingCycle((T)childValue, nodeEquivalence);
    }

    protected abstract T getNodeValue();

    public String toString() {
        return this.propertyName == null ? "<root>" : this.getPropertyName();
    }
}

