/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.options;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.tasks.options.OptionDescriptor;
import org.gradle.api.internal.tasks.options.OptionElement;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceOptionDescriptor
implements OptionDescriptor {
    private final Object object;
    private final OptionElement optionElement;
    private final JavaMethod<Object, Collection> optionValueMethod;

    InstanceOptionDescriptor(Object object, OptionElement optionElement) {
        this(object, optionElement, null);
    }

    public InstanceOptionDescriptor(Object object, OptionElement optionElement, JavaMethod<Object, Collection> optionValueMethod) {
        this.object = object;
        this.optionElement = optionElement;
        this.optionValueMethod = optionValueMethod;
    }

    public OptionElement getOptionElement() {
        return this.optionElement;
    }

    @Override
    public String getName() {
        return this.optionElement.getOptionName();
    }

    @Override
    public Set<String> getAvailableValues() {
        Set<String> values = this.optionElement.getAvailableValues();
        if (this.getArgumentType().isAssignableFrom(String.class)) {
            values.addAll(this.readDynamicAvailableValues());
        }
        return values;
    }

    @Override
    public Class<?> getArgumentType() {
        return this.optionElement.getOptionType();
    }

    private List<String> readDynamicAvailableValues() {
        if (this.optionValueMethod != null) {
            Collection values = this.optionValueMethod.invoke(this.object, new Object[0]);
            return CollectionUtils.toStringList(values);
        }
        return Collections.emptyList();
    }

    @Override
    public String getDescription() {
        return this.optionElement.getDescription();
    }

    @Override
    public void apply(Object objectParam, List<String> parameterValues) {
        if (objectParam != this.object) {
            throw new AssertionError((Object)String.format("Object %s not applyable. Expecting %s", objectParam, this.object));
        }
        this.optionElement.apply(objectParam, parameterValues);
    }

    @Override
    public int compareTo(OptionDescriptor o) {
        return this.getName().compareTo(o.getName());
    }
}

