/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultTaskValidationContext;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class ValidatingTaskExecuter
implements TaskExecuter {
    private final TaskExecuter executer;

    public ValidatingTaskExecuter(TaskExecuter executer) {
        this.executer = executer;
    }

    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        ArrayList messages = Lists.newArrayList();
        FileResolver resolver = ((ProjectInternal)task.getProject()).getFileResolver();
        DefaultTaskValidationContext validationContext = new DefaultTaskValidationContext(resolver, messages);
        try {
            context.getTaskProperties().validate(validationContext);
        }
        catch (Exception ex) {
            throw new TaskExecutionException(task, (Throwable)ex);
        }
        if (!messages.isEmpty()) {
            List<String> firstMessages = messages.subList(0, Math.min(5, messages.size()));
            if (!validationContext.getHighestSeverity().report(task, firstMessages, state)) {
                return;
            }
        }
        this.executer.execute(task, state, context);
    }
}

