/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.io.File;
import java.util.Set;
import org.gradle.api.execution.internal.TaskInputsListener;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.TaskOutputChangesListener;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Cast;
import org.gradle.internal.cleanup.BuildOutputCleanupRegistry;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;
import org.gradle.util.GFileUtils;

public class SkipEmptySourceFilesTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = Logging.getLogger(SkipEmptySourceFilesTaskExecuter.class);
    private final TaskInputsListener taskInputsListener;
    private final BuildOutputCleanupRegistry buildOutputCleanupRegistry;
    private final TaskOutputChangesListener taskOutputChangesListener;
    private final TaskExecuter executer;
    private final BuildInvocationScopeId buildInvocationScopeId;

    public SkipEmptySourceFilesTaskExecuter(TaskInputsListener taskInputsListener, BuildOutputCleanupRegistry buildOutputCleanupRegistry, TaskOutputChangesListener taskOutputChangesListener, TaskExecuter executer, BuildInvocationScopeId buildInvocationScopeId) {
        this.taskInputsListener = taskInputsListener;
        this.buildOutputCleanupRegistry = buildOutputCleanupRegistry;
        this.taskOutputChangesListener = taskOutputChangesListener;
        this.executer = executer;
        this.buildInvocationScopeId = buildInvocationScopeId;
    }

    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        TaskProperties taskProperties = context.getTaskProperties();
        FileCollection sourceFiles = taskProperties.getSourceFiles();
        if (taskProperties.hasSourceFiles() && sourceFiles.isEmpty()) {
            TaskArtifactState taskArtifactState = context.getTaskArtifactState();
            TaskExecutionHistory executionHistory = taskArtifactState.getExecutionHistory();
            Set<File> outputFiles = executionHistory.getOutputFiles();
            if (outputFiles.isEmpty()) {
                state.setOutcome(TaskExecutionOutcome.NO_SOURCE);
                LOGGER.info("Skipping {} as it has no source files and no previous output files.", task);
            } else {
                boolean cleanupDirectories;
                boolean bl = cleanupDirectories = executionHistory.getOverlappingOutputs() == null;
                if (!cleanupDirectories) {
                    LOGGER.info("No leftover directories for {} will be deleted since overlapping outputs were detected.", task);
                }
                this.taskOutputChangesListener.beforeTaskOutputChanged();
                boolean deletedFiles = false;
                boolean debugEnabled = LOGGER.isDebugEnabled();
                for (File file : outputFiles) {
                    if (!file.exists() || !this.buildOutputCleanupRegistry.isOutputOwnedByBuild(file) || !cleanupDirectories && file.isDirectory()) continue;
                    if (debugEnabled) {
                        LOGGER.debug("Deleting stale output file '{}'.", file.getAbsolutePath());
                    }
                    GFileUtils.forceDelete(file);
                    deletedFiles = true;
                }
                if (deletedFiles) {
                    LOGGER.info("Cleaned previous output of {} as it has no source files.", task);
                    state.setOutcome(TaskExecutionOutcome.EXECUTED);
                } else {
                    state.setOutcome(TaskExecutionOutcome.NO_SOURCE);
                }
                taskArtifactState.snapshotAfterTaskExecution(null, this.buildInvocationScopeId.getId(), context);
            }
            this.taskInputsListener.onExecute(task, Cast.cast(FileCollectionInternal.class, sourceFiles));
            return;
        }
        this.taskInputsListener.onExecute(task, Cast.cast(FileCollectionInternal.class, taskProperties.getInputFiles()));
        this.executer.execute(task, state, context);
    }
}

