/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarArchive;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarChangeDependentsFinder;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.tasks.incremental.InputFileDetails;

public class JarChangeProcessor {
    private final FileOperations fileOperations;
    private final JarChangeDependentsFinder dependentsFinder;

    public JarChangeProcessor(FileOperations fileOperations, JarClasspathSnapshot jarClasspathSnapshot, PreviousCompilation previousCompilation) {
        this.fileOperations = fileOperations;
        this.dependentsFinder = new JarChangeDependentsFinder(jarClasspathSnapshot, previousCompilation);
    }

    public void processChange(InputFileDetails input, RecompilationSpec spec) {
        JarArchive jarArchive = new JarArchive(input.getFile(), this.fileOperations.zipTree(input.getFile()));
        DependentsSet actualDependents = this.dependentsFinder.getActualDependents(input, jarArchive);
        if (actualDependents.isDependencyToAll()) {
            spec.setFullRebuildCause(actualDependents.getDescription(), input.getFile());
            return;
        }
        spec.getClassesToCompile().addAll(actualDependents.getDependentClasses());
    }
}

