/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.compile.incremental.deps.AffectedClasses;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarArchive;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.PreviousCompilation;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class JarChangeDependentsFinder {
    private final JarClasspathSnapshot jarClasspathSnapshot;
    private final PreviousCompilation previousCompilation;

    public JarChangeDependentsFinder(JarClasspathSnapshot jarClasspathSnapshot, PreviousCompilation previousCompilation) {
        this.jarClasspathSnapshot = jarClasspathSnapshot;
        this.previousCompilation = previousCompilation;
    }

    public DependentsSet getActualDependents(InputFileDetails jarChangeDetails, JarArchive jarArchive) {
        if (jarChangeDetails.isAdded()) {
            if (this.jarClasspathSnapshot.isAnyClassDuplicated(jarArchive)) {
                return DependentsSet.dependencyToAll("at least one of the classes of '" + jarArchive.file.getName() + "' is already present in classpath");
            }
            return DependentsSet.empty();
        }
        final JarSnapshot previous = this.previousCompilation.getJarSnapshot(jarChangeDetails.getFile());
        if (previous == null) {
            return DependentsSet.dependencyToAll("missing jar snapshot of '" + jarArchive.file.getName() + "' from previous build");
        }
        if (jarChangeDetails.isRemoved()) {
            DependentsSet allClasses = previous.getAllClasses();
            if (allClasses.isDependencyToAll()) {
                return allClasses;
            }
            return this.previousCompilation.getDependents(allClasses.getDependentClasses(), previous.getAllConstants(allClasses));
        }
        if (jarChangeDetails.isModified()) {
            JarSnapshot currentSnapshot = this.jarClasspathSnapshot.getSnapshot(jarArchive);
            AffectedClasses affected = currentSnapshot.getAffectedClassesSince(previous);
            DependentsSet altered = affected.getAltered();
            if (altered.isDependencyToAll()) {
                return altered;
            }
            if (this.jarClasspathSnapshot.isAnyClassDuplicated(affected.getAdded())) {
                return DependentsSet.dependencyToAll("at least one of the classes of modified jar '" + jarArchive.file.getName() + "' is already present in the classpath");
            }
            final HashSet dependentClasses = Sets.newHashSet(altered.getDependentClasses());
            final LinkedList queue = Lists.newLinkedList((Iterable)dependentClasses);
            while (!queue.isEmpty()) {
                final String dependentClass = (String)queue.poll();
                this.jarClasspathSnapshot.forEachSnapshot((Action<? super JarSnapshot>)new Action<JarSnapshot>(){

                    @Override
                    public void execute(JarSnapshot jarSnapshot) {
                        if (jarSnapshot != previous) {
                            ClassSetAnalysisData data = jarSnapshot.getData().data;
                            Set<String> children = data.getChildren(dependentClass);
                            for (String child : children) {
                                if (!dependentClasses.add(child)) continue;
                                queue.add(child);
                            }
                        }
                    }
                });
            }
            return this.previousCompilation.getDependents(dependentClasses, currentSnapshot.getRelevantConstants(previous, dependentClasses));
        }
        throw new IllegalArgumentException("Unknown input file details provided: " + jarChangeDetails);
    }
}

