/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntSet;

public class ClassSetAnalysis {
    private final ClassSetAnalysisData data;

    public ClassSetAnalysis(ClassSetAnalysisData data) {
        this.data = data;
    }

    public DependentsSet getRelevantDependents(Iterable<String> classes, IntSet constants) {
        LinkedHashSet result = null;
        for (String cls : classes) {
            DependentsSet d = this.getRelevantDependents(cls, constants);
            if (d.isDependencyToAll()) {
                return d;
            }
            Set<String> dependentClasses = d.getDependentClasses();
            if (dependentClasses.isEmpty()) continue;
            if (result == null) {
                result = Sets.newLinkedHashSet();
            }
            result.addAll(dependentClasses);
        }
        return result == null ? DependentsSet.empty() : DependentsSet.dependents(result);
    }

    public DependentsSet getRelevantDependents(String className, IntSet constants) {
        DependentsSet deps = this.data.getDependents(className);
        if (deps.isDependencyToAll()) {
            return deps;
        }
        if (!constants.isEmpty()) {
            return DependentsSet.dependencyToAll();
        }
        DependentsSet dependentsOnAll = this.data.getDependentsOnAll();
        if (deps.getDependentClasses().isEmpty() && dependentsOnAll.getDependentClasses().isEmpty()) {
            return deps;
        }
        HashSet<String> result = new HashSet<String>();
        this.recurseDependents(new HashSet<String>(), result, Iterables.concat(deps.getDependentClasses(), dependentsOnAll.getDependentClasses()));
        result.remove(className);
        return DependentsSet.dependents(result);
    }

    public DependentsSet getAggregatedTypes() {
        return this.data.getAggregatedTypes();
    }

    public boolean isDependencyToAll(String className) {
        return this.data.getDependents(className).isDependencyToAll();
    }

    private void recurseDependents(Set<String> visited, Set<String> result, Iterable<String> dependentClasses) {
        for (String d : dependentClasses) {
            DependentsSet currentDependents;
            if (!visited.add(d)) continue;
            if (!this.isNestedClass(d)) {
                result.add(d);
            }
            if ((currentDependents = this.data.getDependents(d)).isDependencyToAll()) continue;
            this.recurseDependents(visited, result, currentDependents.getDependentClasses());
        }
    }

    private boolean isNestedClass(String d) {
        return d.contains("$");
    }

    public ClassSetAnalysisData getData() {
        return this.data;
    }
}

