/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.deps;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessingResult;
import org.gradle.internal.impldep.com.google.common.collect.HashMultimap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntSet;

public class ClassDependentsAccumulator {
    private final Set<String> dependenciesToAll = Sets.newHashSet();
    private final Set<String> aggregatedTypes = Sets.newHashSet();
    private final Set<String> dependentsOnAll = Sets.newHashSet();
    private final Map<String, String> filePathToClassName = new HashMap<String, String>();
    private final Map<String, Set<String>> dependents = new HashMap<String, Set<String>>();
    private final Map<String, IntSet> classesToConstants = new HashMap<String, IntSet>();
    private final Set<String> seenClasses = Sets.newHashSet();
    private final Multimap<String, String> parentToChildren = HashMultimap.create();
    private String fullRebuildCause;

    public void addClass(File classFile, ClassAnalysis classAnalysis) {
        this.addClass(classAnalysis);
        this.filePathToClassName.put(classFile.getAbsolutePath(), classAnalysis.getClassName());
    }

    public void addClass(ClassAnalysis classAnalysis) {
        this.addClass(classAnalysis.getClassName(), classAnalysis.isDependencyToAll(), classAnalysis.getClassDependencies(), classAnalysis.getConstants(), classAnalysis.getSuperTypes());
    }

    public void addClass(String className, boolean dependencyToAll, Iterable<String> classDependencies, IntSet constants, Set<String> superTypes) {
        if (this.seenClasses.contains(className)) {
            return;
        }
        this.seenClasses.add(className);
        this.classesToConstants.put(className, constants);
        if (dependencyToAll) {
            this.dependenciesToAll.add(className);
            this.dependents.remove(className);
        }
        for (String dependency : classDependencies) {
            if (dependency.equals(className) || this.dependenciesToAll.contains(dependency)) continue;
            this.addDependency(dependency, className);
        }
        for (String superType : superTypes) {
            this.parentToChildren.put((Object)superType, (Object)className);
        }
    }

    private Set<String> rememberClass(String className) {
        HashSet d = this.dependents.get(className);
        if (d == null) {
            d = Sets.newHashSet();
            this.dependents.put(className, d);
        }
        return d;
    }

    public Map<String, DependentsSet> getDependentsMap() {
        if (this.dependenciesToAll.isEmpty() && this.dependents.isEmpty()) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String string : this.dependenciesToAll) {
            builder.put((Object)string, (Object)DependentsSet.dependencyToAll());
        }
        for (Map.Entry entry : this.dependents.entrySet()) {
            builder.put(entry.getKey(), (Object)DependentsSet.dependents((Set)entry.getValue()));
        }
        return builder.build();
    }

    public Map<String, IntSet> getClassesToConstants() {
        return this.classesToConstants;
    }

    public void addAnnotationProcessingResult(AnnotationProcessingResult annotationProcessingResult) {
        for (Map.Entry<String, Set<String>> entry : annotationProcessingResult.getGeneratedTypesWithIsolatedOrigin().entrySet()) {
            String originatingType = entry.getKey();
            for (String generatedType : entry.getValue()) {
                this.addDependency(originatingType, generatedType);
                this.addDependency(generatedType, originatingType);
            }
        }
        this.aggregatedTypes.addAll(annotationProcessingResult.getAggregatedTypes());
        this.dependentsOnAll.addAll(annotationProcessingResult.getGeneratedAggregatingTypes());
        if (annotationProcessingResult.getFullRebuildCause() != null) {
            this.fullRebuildCause = annotationProcessingResult.getFullRebuildCause();
        }
    }

    private void addDependency(String dependency, String dependent) {
        Set<String> dependents = this.rememberClass(dependency);
        dependents.add(dependent);
    }

    public void fullRebuildNeeded(String fullRebuildCause) {
        this.fullRebuildCause = fullRebuildCause;
    }

    public ClassSetAnalysisData getAnalysis() {
        return new ClassSetAnalysisData(this.filePathToClassName, this.getDependentsMap(), this.getClassesToConstants(), ClassDependentsAccumulator.asMap(this.parentToChildren), DependentsSet.dependents(this.aggregatedTypes), DependentsSet.dependents(this.dependentsOnAll), this.fullRebuildCause);
    }

    private static <K, V> Map<K, Set<V>> asMap(Multimap<K, V> multimap) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Object key : multimap.keySet()) {
            builder.put(key, (Object)ImmutableSet.copyOf((Collection)multimap.get(key)));
        }
        return builder.build();
    }
}

