/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.cache;

import java.io.Closeable;
import java.io.File;
import java.util.List;
import org.gradle.api.internal.changedetection.state.InMemoryCacheDecoratorFactory;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassAnalysisCache;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassAnalysisSerializer;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.DefaultClassAnalysisCache;
import org.gradle.api.internal.tasks.compile.incremental.cache.GeneralCompileCaches;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.deps.LocalClassSetAnalysisStore;
import org.gradle.api.internal.tasks.compile.incremental.jar.DefaultJarSnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshotData;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshotDataSerializer;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotData;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotDataSerializer;
import org.gradle.api.internal.tasks.compile.incremental.jar.LocalJarClasspathSnapshotStore;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessorPathStore;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.ListSerializer;

public class DefaultGeneralCompileCaches
implements GeneralCompileCaches,
Closeable {
    private final ClassAnalysisCache classAnalysisCache;
    private final JarSnapshotCache jarSnapshotCache;
    private final PersistentCache cache;
    private final PersistentIndexedCache<String, JarClasspathSnapshotData> taskJarCache;
    private final PersistentIndexedCache<String, ClassSetAnalysisData> taskCompileCache;
    private final PersistentIndexedCache<String, List<File>> taskProcessorPathCache;

    public DefaultGeneralCompileCaches(CacheRepository cacheRepository, Gradle gradle, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
        this.cache = cacheRepository.cache(gradle, "javaCompile").withDisplayName("Java compile cache").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.None)).open();
        PersistentIndexedCacheParameters<HashCode, ClassAnalysis> classCacheParameters = new PersistentIndexedCacheParameters<HashCode, ClassAnalysis>("classAnalysis", new HashCodeSerializer(), new ClassAnalysisSerializer()).cacheDecorator(inMemoryCacheDecoratorFactory.decorator(400000, true));
        this.classAnalysisCache = new DefaultClassAnalysisCache(this.cache.createCache(classCacheParameters));
        PersistentIndexedCacheParameters<HashCode, JarSnapshotData> jarCacheParameters = new PersistentIndexedCacheParameters<HashCode, JarSnapshotData>("jarAnalysis", new HashCodeSerializer(), new JarSnapshotDataSerializer()).cacheDecorator(inMemoryCacheDecoratorFactory.decorator(20000, true));
        this.jarSnapshotCache = new DefaultJarSnapshotCache(this.cache.createCache(jarCacheParameters));
        PersistentIndexedCacheParameters<String, JarClasspathSnapshotData> taskJarCacheParameters = new PersistentIndexedCacheParameters<String, JarClasspathSnapshotData>("taskJars", String.class, new JarClasspathSnapshotDataSerializer()).cacheDecorator(inMemoryCacheDecoratorFactory.decorator(2000, false));
        this.taskJarCache = this.cache.createCache(taskJarCacheParameters);
        PersistentIndexedCacheParameters<String, ClassSetAnalysisData> taskCompileCacheParameters = new PersistentIndexedCacheParameters<String, ClassSetAnalysisData>("taskHistory", String.class, new ClassSetAnalysisData.Serializer()).cacheDecorator(inMemoryCacheDecoratorFactory.decorator(2000, false));
        this.taskCompileCache = this.cache.createCache(taskCompileCacheParameters);
        PersistentIndexedCacheParameters<String, File> taskProcessorPathCacheParameters = new PersistentIndexedCacheParameters<String, File>("processorPath", String.class, new ListSerializer<File>(BaseSerializerFactory.FILE_SERIALIZER)).cacheDecorator(inMemoryCacheDecoratorFactory.decorator(2000, false));
        this.taskProcessorPathCache = this.cache.createCache(taskProcessorPathCacheParameters);
    }

    @Override
    public void close() {
        this.cache.close();
    }

    @Override
    public ClassAnalysisCache getClassAnalysisCache() {
        return this.classAnalysisCache;
    }

    @Override
    public JarSnapshotCache getJarSnapshotCache() {
        return this.jarSnapshotCache;
    }

    @Override
    public LocalJarClasspathSnapshotStore createLocalJarClasspathSnapshotStore(String taskPath) {
        return new LocalJarClasspathSnapshotStore(taskPath, this.taskJarCache);
    }

    @Override
    public LocalClassSetAnalysisStore createLocalClassSetAnalysisStore(String taskPath) {
        return new LocalClassSetAnalysisStore(taskPath, this.taskCompileCache);
    }

    @Override
    public AnnotationProcessorPathStore createAnnotationProcessorPathStore(String taskpath) {
        return new AnnotationProcessorPathStore(taskpath, this.taskProcessorPathCache);
    }
}

