/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.analyzer;

import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassDependentsAccumulator;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessingResult;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;

public class CompilationResultAnalyzer
implements FileVisitor {
    private static final Logger LOGGER = Logging.getLogger(CompilationResultAnalyzer.class);
    private final ClassDependenciesAnalyzer analyzer;
    private final ClassDependentsAccumulator accumulator;
    private final FileHasher hasher;

    public CompilationResultAnalyzer(ClassDependenciesAnalyzer analyzer, FileHasher fileHasher) {
        this(analyzer, fileHasher, new ClassDependentsAccumulator());
    }

    CompilationResultAnalyzer(ClassDependenciesAnalyzer analyzer, FileHasher fileHasher, ClassDependentsAccumulator accumulator) {
        this.analyzer = analyzer;
        this.hasher = fileHasher;
        this.accumulator = accumulator;
    }

    @Override
    public void visitDir(FileVisitDetails dirDetails) {
    }

    @Override
    public void visitFile(FileVisitDetails fileDetails) {
        block3: {
            if (!fileDetails.getName().endsWith(".class")) {
                return;
            }
            HashCode hash = this.hasher.hash(fileDetails);
            try {
                ClassAnalysis analysis = this.analyzer.getClassAnalysis(hash, fileDetails);
                this.accumulator.addClass(fileDetails.getFile(), analysis);
            }
            catch (Exception e) {
                this.accumulator.fullRebuildNeeded("class file " + fileDetails.getName() + " could not be analyzed. See the debug log for more details");
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug("Could not analyze class file " + fileDetails.getName(), e);
            }
        }
    }

    public ClassSetAnalysisData getAnalysis() {
        return this.accumulator.getAnalysis();
    }

    public void visitAnnotationProcessingResult(AnnotationProcessingResult annotationProcessingResult) {
        if (annotationProcessingResult == null) {
            this.accumulator.fullRebuildNeeded("the chosen compiler did not support incremental annotation processing");
        } else {
            this.accumulator.addAnnotationProcessingResult(annotationProcessingResult);
        }
    }
}

