/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.analyzer;

import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntSet;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.IntSetSerializer;
import org.gradle.internal.serialize.SetSerializer;

public class ClassAnalysisSerializer
extends AbstractSerializer<ClassAnalysis> {
    private static final SetSerializer<String> STRING_SET_SERIALIZER = new SetSerializer<String>(BaseSerializerFactory.STRING_SERIALIZER, false);

    @Override
    public ClassAnalysis read(Decoder decoder) throws Exception {
        String className = decoder.readString();
        boolean relatedToAll = decoder.readBoolean();
        Set classes = (Set)STRING_SET_SERIALIZER.read(decoder);
        IntSet constants = IntSetSerializer.INSTANCE.read(decoder);
        Set superTypes = (Set)STRING_SET_SERIALIZER.read(decoder);
        return new ClassAnalysis(className, classes, relatedToAll, constants, superTypes);
    }

    @Override
    public void write(Encoder encoder, ClassAnalysis value) throws Exception {
        encoder.writeString(value.getClassName());
        encoder.writeBoolean(value.isDependencyToAll());
        STRING_SET_SERIALIZER.write(encoder, value.getClassDependencies());
        IntSetSerializer.INSTANCE.write(encoder, value.getConstants());
        STRING_SET_SERIALIZER.write(encoder, value.getSuperTypes());
    }
}

