/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.changedetection.rules.FileChange;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.incremental.AnnotationProcessorChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.ClassChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.CurrentCompilation;
import org.gradle.api.internal.tasks.compile.incremental.InputChangeAction;
import org.gradle.api.internal.tasks.compile.incremental.JavaChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.SourceToNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.internal.file.FileType;
import org.gradle.internal.util.Alignment;

public class RecompilationSpecProvider {
    private final SourceToNameConverter sourceToNameConverter;
    private final FileOperations fileOperations;

    RecompilationSpecProvider(SourceToNameConverter sourceToNameConverter, FileOperations fileOperations) {
        this.sourceToNameConverter = sourceToNameConverter;
        this.fileOperations = fileOperations;
    }

    public RecompilationSpec provideRecompilationSpec(CurrentCompilation current, PreviousCompilation previous) {
        RecompilationSpec spec = new RecompilationSpec();
        this.processJarClasspathChanges(current, previous, spec);
        this.processOtherChanges(current, previous, spec);
        spec.getClassesToProcess().addAll(previous.getAggregatedTypes().getDependentClasses());
        return spec;
    }

    private void processJarClasspathChanges(CurrentCompilation current, PreviousCompilation previous, RecompilationSpec spec) {
        JarChangeProcessor jarChangeProcessor = new JarChangeProcessor(this.fileOperations, current.getClasspathSnapshot(), previous);
        Map<File, JarSnapshot> previousCompilationJarSnapshots = previous.getJarSnapshots();
        JarClasspathSnapshot currentJarSnapshots = current.getClasspathSnapshot();
        Set<File> previousCompilationJars = previousCompilationJarSnapshots.keySet();
        Set<File> currentCompilationJars = currentJarSnapshots.getJars();
        List<Alignment<File>> alignment = Alignment.align(currentCompilationJars.toArray(new File[0]), previousCompilationJars.toArray(new File[0]));
        for (Alignment<File> fileAlignment : alignment) {
            switch (fileAlignment.getKind()) {
                case added: {
                    jarChangeProcessor.processChange(FileChange.added(fileAlignment.getCurrentValue().getAbsolutePath(), "jar", FileType.RegularFile), spec);
                    break;
                }
                case removed: {
                    jarChangeProcessor.processChange(FileChange.removed(fileAlignment.getPreviousValue().getAbsolutePath(), "jar", FileType.RegularFile), spec);
                    break;
                }
                case transformed: {
                    spec.setFullRebuildCause("Classpath has been changed", null);
                    return;
                }
                case identical: {
                    File key = fileAlignment.getPreviousValue();
                    JarSnapshot previousSnapshot = previousCompilationJarSnapshots.get(key);
                    JarSnapshot snapshot = currentJarSnapshots.getSnapshot(key);
                    if (snapshot.getHash().equals(previousSnapshot.getHash())) break;
                    jarChangeProcessor.processChange(FileChange.modified(key.getAbsolutePath(), "jar", FileType.RegularFile, FileType.RegularFile), spec);
                }
            }
        }
    }

    private void processOtherChanges(CurrentCompilation current, PreviousCompilation previous, RecompilationSpec spec) {
        JavaChangeProcessor javaChangeProcessor = new JavaChangeProcessor(previous, this.sourceToNameConverter);
        ClassChangeProcessor classChangeProcessor = new ClassChangeProcessor(previous);
        AnnotationProcessorChangeProcessor annotationProcessorChangeProcessor = new AnnotationProcessorChangeProcessor(current, previous);
        InputChangeAction action = new InputChangeAction(spec, javaChangeProcessor, classChangeProcessor, annotationProcessorChangeProcessor);
        current.visitChanges(action);
    }
}

