/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import org.gradle.api.internal.tasks.compile.incremental.SourceToNameConverter;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.jar.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntSet;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntSets;

class JavaChangeProcessor {
    private final SourceToNameConverter sourceToNameConverter;
    private final PreviousCompilation previousCompilation;

    public JavaChangeProcessor(PreviousCompilation previousCompilation, SourceToNameConverter sourceToNameConverter) {
        this.previousCompilation = previousCompilation;
        this.sourceToNameConverter = sourceToNameConverter;
    }

    public void processChange(InputFileDetails input, RecompilationSpec spec) {
        String className = this.sourceToNameConverter.getClassName(input.getFile());
        spec.getClassesToCompile().add(className);
        DependentsSet actualDependents = this.previousCompilation.getDependents(className, (IntSet)IntSets.EMPTY_SET);
        if (actualDependents.isDependencyToAll()) {
            spec.setFullRebuildCause(actualDependents.getDescription(), input.getFile());
            return;
        }
        spec.getClassesToCompile().addAll(actualDependents.getDependentClasses());
    }
}

