/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.ClassSetAnalysisUpdater;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshotWriter;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessorPathStore;
import org.gradle.api.tasks.WorkResult;
import org.gradle.language.base.internal.compile.Compiler;

class IncrementalResultStoringDecorator
implements Compiler<JavaCompileSpec> {
    private final Compiler<JavaCompileSpec> delegate;
    private final JarClasspathSnapshotWriter writer;
    private final ClassSetAnalysisUpdater updater;
    private final AnnotationProcessorPathStore annotationProcessorPathStore;

    public IncrementalResultStoringDecorator(Compiler<JavaCompileSpec> delegate, JarClasspathSnapshotWriter writer, ClassSetAnalysisUpdater updater, AnnotationProcessorPathStore annotationProcessorPathStore) {
        this.delegate = delegate;
        this.writer = writer;
        this.updater = updater;
        this.annotationProcessorPathStore = annotationProcessorPathStore;
    }

    @Override
    public WorkResult execute(JavaCompileSpec spec) {
        WorkResult out = this.delegate.execute(spec);
        this.updater.updateAnalysis(spec, out);
        this.writer.storeJarSnapshots(spec.getCompileClasspath());
        this.annotationProcessorPathStore.put(spec.getAnnotationProcessorPath());
        return out;
    }
}

