/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JdkJavaCompilerResult;
import org.gradle.api.internal.tasks.compile.incremental.RecompilationNotNecessary;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.CompilationResultAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessingResult;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.cache.internal.Stash;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;

public class ClassSetAnalysisUpdater {
    private static final Logger LOG = Logging.getLogger(ClassSetAnalysisUpdater.class);
    private static final Predicate<File> IS_CLASS_DIRECTORY = new Predicate<File>(){

        public boolean apply(File input) {
            return input.isDirectory();
        }
    };
    private final Stash<ClassSetAnalysisData> stash;
    private final FileOperations fileOperations;
    private ClassDependenciesAnalyzer analyzer;
    private final FileHasher fileHasher;

    ClassSetAnalysisUpdater(Stash<ClassSetAnalysisData> stash, FileOperations fileOperations, ClassDependenciesAnalyzer analyzer, FileHasher fileHasher) {
        this.stash = stash;
        this.fileOperations = fileOperations;
        this.analyzer = analyzer;
        this.fileHasher = fileHasher;
    }

    public void updateAnalysis(JavaCompileSpec spec, WorkResult result) {
        if (result instanceof RecompilationNotNecessary) {
            return;
        }
        Timer clock = Time.startTimer();
        CompilationResultAnalyzer analyzer = new CompilationResultAnalyzer(this.analyzer, this.fileHasher);
        this.visitAnnotationProcessingResult(spec, result, analyzer);
        this.visitClassFiles(spec, analyzer);
        ClassSetAnalysisData data = analyzer.getAnalysis();
        this.stash.put(data);
        LOG.info("Class dependency analysis for incremental compilation took {}.", clock.getElapsed());
    }

    private void visitAnnotationProcessingResult(JavaCompileSpec spec, WorkResult result, CompilationResultAnalyzer analyzer) {
        if (!spec.getEffectiveAnnotationProcessors().isEmpty()) {
            AnnotationProcessingResult annotationProcessingResult = null;
            if (result instanceof JdkJavaCompilerResult) {
                annotationProcessingResult = ((JdkJavaCompilerResult)result).getAnnotationProcessingResult();
            }
            analyzer.visitAnnotationProcessingResult(annotationProcessingResult);
        }
    }

    private void visitClassFiles(JavaCompileSpec spec, CompilationResultAnalyzer analyzer) {
        LinkedHashSet baseDirs = Sets.newLinkedHashSet();
        baseDirs.add(spec.getDestinationDir());
        Iterables.addAll((Collection)baseDirs, (Iterable)Iterables.filter(spec.getCompileClasspath(), IS_CLASS_DIRECTORY));
        for (File baseDir : baseDirs) {
            this.fileOperations.fileTree(baseDir).visit(analyzer);
        }
    }
}

