/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental;

import java.io.File;
import java.io.IOException;
import org.gradle.api.internal.tasks.compile.incremental.asm.ClassDependenciesVisitor;
import org.gradle.api.internal.tasks.compile.incremental.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.jar.PreviousCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntSet;
import org.gradle.internal.impldep.it.unimi.dsi.fastutil.ints.IntSets;
import org.gradle.internal.impldep.org.objectweb.asm.ClassReader;

public class ClassChangeProcessor {
    private final PreviousCompilation previousCompilation;

    public ClassChangeProcessor(PreviousCompilation previousCompilation) {
        this.previousCompilation = previousCompilation;
    }

    public void processChange(InputFileDetails input, RecompilationSpec spec) {
        if (input.isRemoved()) {
            String className = this.previousCompilation.getClassName(input.getFile().getAbsolutePath());
            this.update(input, spec, className, (IntSet)IntSets.EMPTY_SET);
            return;
        }
        try {
            ClassReader classReader = new ClassReader(Files.toByteArray((File)input.getFile()));
            String className = classReader.getClassName().replaceAll("/", ".");
            IntSet constants = ClassDependenciesVisitor.retrieveConstants(classReader);
            this.update(input, spec, className, constants);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Unable to read class file: '%s'", input.getFile()));
        }
    }

    protected void update(InputFileDetails input, RecompilationSpec spec, String className, IntSet newConstants) {
        DependentsSet actualDependents = this.previousCompilation.getDependents(className, newConstants);
        if (actualDependents.isDependencyToAll()) {
            spec.setFullRebuildCause(actualDependents.getDescription(), input.getFile());
        } else {
            spec.getClassesToCompile().addAll(actualDependents.getDependentClasses());
        }
    }
}

