/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.HashSet;
import java.util.Iterator;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultPropertySpecFactory;
import org.gradle.api.internal.tasks.DefaultTaskDestroyablePropertySpec;
import org.gradle.api.internal.tasks.DefaultTaskLocalStatePropertySpec;
import org.gradle.api.internal.tasks.TaskDestroyablesInternal;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.api.internal.tasks.TaskLocalStateInternal;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public class TaskPropertyUtils {
    public static void visitProperties(PropertyWalker propertyWalker, TaskInternal task, PropertyVisitor visitor) {
        DefaultPropertySpecFactory specFactory = new DefaultPropertySpecFactory(task, ((ProjectInternal)task.getProject()).getFileResolver());
        propertyWalker.visitProperties(specFactory, visitor, task);
        task.getInputs().visitRegisteredProperties(visitor);
        task.getOutputs().visitRegisteredProperties(visitor);
        int destroyableCount = 0;
        for (Object path : ((TaskDestroyablesInternal)task.getDestroyables()).getRegisteredPaths()) {
            visitor.visitDestroyableProperty(new DefaultTaskDestroyablePropertySpec("$" + ++destroyableCount, path));
        }
        int localStateCount = 0;
        for (Object path : ((TaskLocalStateInternal)task.getLocalState()).getRegisteredPaths()) {
            visitor.visitLocalStateProperty(new DefaultTaskLocalStatePropertySpec("$" + ++localStateCount, path));
        }
    }

    public static <T extends TaskFilePropertySpec> ImmutableSortedSet<T> collectFileProperties(String displayName, Iterator<? extends T> fileProperties) {
        HashSet names = Sets.newHashSet();
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        while (fileProperties.hasNext()) {
            TaskFilePropertySpec propertySpec = (TaskFilePropertySpec)fileProperties.next();
            String propertyName = propertySpec.getPropertyName();
            if (!names.add(propertyName)) {
                throw new IllegalArgumentException(String.format("Multiple %s file properties with name '%s'", displayName, propertyName));
            }
            builder.add((Object)propertySpec);
        }
        return builder.build();
    }

    public static String checkPropertyName(String propertyName) {
        if (propertyName.isEmpty()) {
            throw new IllegalArgumentException("Property name must not be empty string");
        }
        return propertyName;
    }
}

