/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import org.gradle.api.Action;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.SourceDirectorySetFactory;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.GroovySourceSet;
import org.gradle.util.ConfigureUtil;

public class DefaultGroovySourceSet
implements GroovySourceSet,
HasPublicType {
    private final SourceDirectorySet groovy;
    private final SourceDirectorySet allGroovy;

    public DefaultGroovySourceSet(String name, String displayName, SourceDirectorySetFactory sourceDirectorySetFactory) {
        this.groovy = sourceDirectorySetFactory.create(name, displayName + " Groovy source");
        this.groovy.getFilter().include("**/*.java", "**/*.groovy");
        this.allGroovy = sourceDirectorySetFactory.create(displayName + " Groovy source");
        this.allGroovy.source(this.groovy);
        this.allGroovy.getFilter().include("**/*.groovy");
    }

    @Override
    public SourceDirectorySet getGroovy() {
        return this.groovy;
    }

    @Override
    public GroovySourceSet groovy(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getGroovy());
        return this;
    }

    @Override
    public GroovySourceSet groovy(Action<? super SourceDirectorySet> configureAction) {
        configureAction.execute(this.getGroovy());
        return this;
    }

    @Override
    public SourceDirectorySet getAllGroovy() {
        return this.allGroovy;
    }

    @Override
    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(GroovySourceSet.class);
    }
}

