/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.runtimeshaded;

import java.io.File;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.runtimeshaded.ImplementationDependencyRelocator;
import org.gradle.api.internal.runtimeshaded.RuntimeShadedJarCreator;
import org.gradle.api.internal.runtimeshaded.RuntimeShadedJarType;
import org.gradle.cache.internal.GeneratedGradleJarCache;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeShadedJarFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeShadedJarFactory.class);
    private final GeneratedGradleJarCache cache;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final BuildOperationExecutor buildOperationExecutor;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;

    public RuntimeShadedJarFactory(GeneratedGradleJarCache cache, ProgressLoggerFactory progressLoggerFactory, BuildOperationExecutor buildOperationExecutor, DirectoryFileTreeFactory directoryFileTreeFactory) {
        this.cache = cache;
        this.progressLoggerFactory = progressLoggerFactory;
        this.buildOperationExecutor = buildOperationExecutor;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
    }

    public File get(final RuntimeShadedJarType type, final Collection<? extends File> classpath) {
        File jarFile = this.cache.get(type.getIdentifier(), new Action<File>(){

            @Override
            public void execute(final File file) {
                RuntimeShadedJarFactory.this.buildOperationExecutor.run(new RunnableBuildOperation(){

                    @Override
                    public void run(BuildOperationContext context) {
                        RuntimeShadedJarCreator creator = new RuntimeShadedJarCreator(RuntimeShadedJarFactory.this.progressLoggerFactory, new ImplementationDependencyRelocator(type), RuntimeShadedJarFactory.this.directoryFileTreeFactory);
                        creator.create(file, classpath);
                    }

                    @Override
                    public BuildOperationDescriptor.Builder description() {
                        String displayName = "Generating Jar " + file.getName();
                        return BuildOperationDescriptor.displayName(displayName).progressDisplayName(displayName);
                    }
                });
            }
        });
        LOGGER.debug("Using Gradle runtime shaded JAR file: {}", (Object)jarFile);
        return jarFile;
    }
}

