/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.util.concurrent.Callable;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.api.tasks.TaskInstantiationException;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.NameValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskFactory
implements ITaskFactory {
    private static final Object[] NO_ARGS = new Object[0];
    private final ClassGenerator generator;
    private final ProjectInternal project;
    private final Instantiator instantiator;

    public TaskFactory(ClassGenerator generator) {
        this(generator, null, null);
    }

    TaskFactory(ClassGenerator generator, ProjectInternal project, Instantiator instantiator) {
        this.generator = generator;
        this.project = project;
        this.instantiator = instantiator;
    }

    @Override
    public ITaskFactory createChild(ProjectInternal project, Instantiator instantiator) {
        return new TaskFactory(this.generator, project, instantiator);
    }

    @Override
    public <S extends Task> S create(String name, Class<S> type) {
        return this.create(name, type, NO_ARGS);
    }

    @Override
    public <S extends Task> S create(String name, final Class<S> type, final Object ... args) {
        if (!Task.class.isAssignableFrom(type)) {
            throw new InvalidUserDataException(String.format("Cannot create task of type '%s' as it does not implement the Task interface.", type.getSimpleName()));
        }
        NameValidator.validate(name, "task name", "");
        final Class<DefaultTask> generatedType = type.isAssignableFrom(DefaultTask.class) ? this.generator.generate(DefaultTask.class) : this.generator.generate(type);
        return (S)((Task)type.cast(AbstractTask.injectIntoNewInstance(this.project, name, type, new Callable<Task>(){

            @Override
            public Task call() throws Exception {
                try {
                    return (Task)TaskFactory.this.instantiator.newInstance(generatedType, args);
                }
                catch (ObjectInstantiationException e) {
                    throw new TaskInstantiationException(String.format("Could not create task of type '%s'.", type.getSimpleName()), e.getCause());
                }
            }
        })));
    }
}

