/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.Pair;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.util.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProjectStateRegistry
implements ProjectStateRegistry {
    private final Object lock = new Object();
    private final Map<Path, ProjectStateImpl> projectsByPath = Maps.newLinkedHashMap();
    private final Map<ProjectComponentIdentifier, ProjectStateImpl> projectsById = Maps.newLinkedHashMap();
    private final Map<Pair<BuildIdentifier, Path>, ProjectStateImpl> projectsByCompId = Maps.newLinkedHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerProjects(BuildState owner) {
        Object object = this.lock;
        synchronized (object) {
            for (DefaultProjectDescriptor descriptor : owner.getLoadedSettings().getProjectRegistry().getAllProjects()) {
                Path identityPath = owner.getIdentityPathForProject(descriptor.path());
                ProjectComponentIdentifier projectIdentifier = owner.getIdentifierForProject(descriptor.path());
                ProjectStateImpl projectState = new ProjectStateImpl(owner, identityPath, descriptor.getName(), projectIdentifier);
                this.projectsByPath.put(identityPath, projectState);
                this.projectsById.put(projectIdentifier, projectState);
                this.projectsByCompId.put(Pair.of(owner.getBuildIdentifier(), descriptor.path()), projectState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(BuildState owner, ProjectInternal project) {
        Object object = this.lock;
        synchronized (object) {
            Path identityPath = project.getIdentityPath();
            ProjectComponentIdentifier projectIdentifier = owner.getIdentifierForProject(project.getProjectPath());
            ProjectStateImpl projectState = new ProjectStateImpl(owner, identityPath, project.getName(), projectIdentifier);
            this.projectsByPath.put(projectState.projectIdentityPath, projectState);
            this.projectsById.put(projectState.identifier, projectState);
            this.projectsByCompId.put(Pair.of(owner.getBuildIdentifier(), project.getProjectPath()), projectState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ProjectStateImpl> getAllProjects() {
        Object object = this.lock;
        synchronized (object) {
            return this.projectsByPath.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectState stateFor(Project project) {
        Object object = this.lock;
        synchronized (object) {
            ProjectStateImpl projectState = this.projectsByPath.get(((ProjectInternal)project).getIdentityPath());
            if (projectState == null) {
                throw new IllegalArgumentException("Could not find state for " + project);
            }
            return projectState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectState stateFor(ProjectComponentIdentifier identifier) {
        Object object = this.lock;
        synchronized (object) {
            ProjectStateImpl projectState = this.projectsById.get(identifier);
            if (projectState == null) {
                throw new IllegalArgumentException(identifier.getDisplayName() + " not found.");
            }
            return projectState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectState stateFor(BuildIdentifier buildIdentifier, Path projectPath) {
        Object object = this.lock;
        synchronized (object) {
            ProjectStateImpl projectState = this.projectsByCompId.get(Pair.of(buildIdentifier, projectPath));
            if (projectState == null) {
                throw new IllegalArgumentException(buildIdentifier + " project " + projectPath + " not found.");
            }
            return projectState;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProjectStateImpl
    implements ProjectState {
        private final String projectName;
        private final ProjectComponentIdentifier identifier;
        private final BuildState owner;
        private final Path projectIdentityPath;

        ProjectStateImpl(BuildState owner, Path projectIdentityPath, String projectName, ProjectComponentIdentifier identifier) {
            this.owner = owner;
            this.projectIdentityPath = projectIdentityPath;
            this.projectName = projectName;
            this.identifier = identifier;
        }

        public String toString() {
            return this.identifier.getDisplayName();
        }

        @Override
        public BuildState getOwner() {
            return this.owner;
        }

        @Override
        @Nullable
        public ProjectState getParent() {
            return this.projectIdentityPath.getParent() == null ? null : (ProjectStateImpl)DefaultProjectStateRegistry.this.projectsByPath.get(this.projectIdentityPath.getParent());
        }

        @Override
        public String getName() {
            return this.projectName;
        }

        @Override
        public ProjectComponentIdentifier getComponentIdentifier() {
            return this.identifier;
        }

        @Override
        public <T> void withMutableState(Runnable action) {
            this.withMutableState(Factories.toFactory(action));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T withMutableState(Factory<? extends T> action) {
            ProjectStateImpl projectStateImpl = this;
            synchronized (projectStateImpl) {
                return action.create();
            }
        }
    }
}

