/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.internal.plugins.DefaultPluginCollection;
import org.gradle.api.internal.plugins.PluginImplementation;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.plugins.PluginCollection;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.api.specs.Spec;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.plugin.use.internal.DefaultPluginId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPluginContainer
extends DefaultPluginCollection<Plugin>
implements PluginContainer {
    private final PluginRegistry pluginRegistry;
    private final PluginManagerInternal pluginManager;

    public DefaultPluginContainer(PluginRegistry pluginRegistry, PluginManagerInternal pluginManager) {
        super(Plugin.class);
        this.pluginRegistry = pluginRegistry;
        this.pluginManager = pluginManager;
    }

    void pluginAdded(Plugin plugin) {
        super.add(plugin);
    }

    @Override
    public boolean add(Plugin toAdd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Plugin> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Plugin apply(String id) {
        PluginImplementation<?> plugin = this.pluginRegistry.lookup(DefaultPluginId.unvalidated(id));
        if (plugin == null) {
            throw new UnknownPluginException("Plugin with id '" + id + "' not found.");
        }
        if (!Plugin.class.isAssignableFrom(plugin.asClass())) {
            throw new IllegalArgumentException("Plugin implementation '" + plugin.asClass().getName() + "' does not implement the Plugin interface. This plugin cannot be applied directly via the PluginContainer.");
        }
        return this.pluginManager.addImperativePlugin(plugin);
    }

    public <P extends Plugin> P apply(Class<P> type) {
        return this.pluginManager.addImperativePlugin(type);
    }

    @Override
    public boolean hasPlugin(String id) {
        return this.findPlugin(id) != null;
    }

    @Override
    public boolean hasPlugin(Class<? extends Plugin> type) {
        return this.findPlugin((Class)type) != null;
    }

    private Plugin doFindPlugin(String id) {
        for (final PluginManagerInternal.PluginWithId pluginWithId : this.pluginManager.pluginsForId(id)) {
            Plugin plugin = (Plugin)Iterables.tryFind((Iterable)this, (Predicate)new Predicate<Plugin>(){

                public boolean apply(Plugin plugin) {
                    return pluginWithId.clazz.equals(plugin.getClass());
                }
            }).orNull();
            if (plugin == null) continue;
            return plugin;
        }
        return null;
    }

    @Override
    public Plugin findPlugin(String id) {
        return this.doFindPlugin(id);
    }

    public <P extends Plugin> P findPlugin(Class<P> type) {
        for (Plugin plugin : this) {
            if (!plugin.getClass().equals(type)) continue;
            return (P)((Plugin)type.cast(plugin));
        }
        return null;
    }

    @Override
    public Plugin getPlugin(String id) {
        Plugin plugin = this.findPlugin(id);
        if (plugin == null) {
            throw new UnknownPluginException("Plugin with id " + id + " has not been used.");
        }
        return plugin;
    }

    @Override
    public Plugin getAt(String id) throws UnknownPluginException {
        return this.getPlugin(id);
    }

    public <P extends Plugin> P getAt(Class<P> type) throws UnknownPluginException {
        return this.getPlugin(type);
    }

    public <P extends Plugin> P getPlugin(Class<P> type) throws UnknownPluginException {
        P plugin = this.findPlugin(type);
        if (plugin == null) {
            throw new UnknownPluginException("Plugin with type " + type + " has not been used.");
        }
        return (P)((Plugin)type.cast(plugin));
    }

    @Override
    public void withId(String pluginId, final Action<? super Plugin> action) {
        Action<PluginManagerInternal.PluginWithId> wrappedAction = new Action<PluginManagerInternal.PluginWithId>(){

            @Override
            public void execute(final PluginManagerInternal.PluginWithId pluginWithId) {
                DefaultPluginContainer.this.matching(new Spec<Plugin>(){

                    @Override
                    public boolean isSatisfiedBy(Plugin element) {
                        return pluginWithId.clazz.equals(element.getClass());
                    }
                }).all(action);
            }
        };
        this.pluginManager.pluginsForId(pluginId).all(wrappedAction);
    }

    @Override
    public <S extends Plugin> PluginCollection<S> withType(Class<S> type) {
        if (!Plugin.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("'%s' does not implement the Plugin interface.", type.getName()));
        }
        return super.withType((Class)type);
    }
}

