/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;

public class DefaultArtifactPublicationSet {
    private final PublishArtifactSet artifacts;
    private PublishArtifact defaultArtifact;

    public DefaultArtifactPublicationSet(PublishArtifactSet artifacts) {
        this.artifacts = artifacts;
    }

    public void addCandidate(PublishArtifact artifact) {
        String thisType = artifact.getType();
        if (this.defaultArtifact == null) {
            this.artifacts.add(artifact);
            this.defaultArtifact = artifact;
            return;
        }
        String currentType = this.defaultArtifact.getType();
        if (thisType.equals("ear")) {
            this.replaceCurrent(artifact);
        } else if (thisType.equals("war")) {
            if (currentType.equals("jar")) {
                this.replaceCurrent(artifact);
            }
        } else if (!thisType.equals("jar")) {
            this.artifacts.add(artifact);
        }
    }

    private void replaceCurrent(PublishArtifact artifact) {
        this.artifacts.remove(this.defaultArtifact);
        this.artifacts.add(artifact);
        this.defaultArtifact = artifact;
    }
}

