/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.internal.plugins.AbstractRule;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;

public class BuildConfigurationRule
extends AbstractRule {
    public static final String PREFIX = "build";
    private final ConfigurationContainer configurations;
    private final TaskContainer tasks;

    public BuildConfigurationRule(ConfigurationContainer configurations, TaskContainer tasks) {
        this.configurations = configurations;
        this.tasks = tasks;
    }

    @Override
    public String getDescription() {
        return "Pattern: build<ConfigurationName>: Assembles the artifacts of a configuration.";
    }

    @Override
    public void apply(String taskName) {
        String configurationName;
        Configuration configuration;
        if (taskName.startsWith(PREFIX) && (configuration = (Configuration)this.configurations.findByName(configurationName = StringUtils.uncapitalize((String)taskName.substring(PREFIX.length())))) != null) {
            Task task = this.tasks.create(taskName);
            task.dependsOn(configuration.getAllArtifacts());
            task.setDescription("Builds the artifacts belonging to " + configuration + ".");
        }
    }
}

