/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.model;

import org.gradle.api.Named;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.api.internal.provider.DefaultListProperty;
import org.gradle.api.internal.provider.DefaultProviderFactory;
import org.gradle.api.internal.provider.DefaultSetProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.internal.reflect.Instantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObjectFactory
implements ObjectFactory {
    private final Instantiator instantiator;
    private final NamedObjectInstantiator namedObjectInstantiator;
    private final DefaultProviderFactory providerFactory;

    public DefaultObjectFactory(Instantiator instantiator, NamedObjectInstantiator namedObjectInstantiator) {
        this.instantiator = instantiator;
        this.namedObjectInstantiator = namedObjectInstantiator;
        this.providerFactory = new DefaultProviderFactory();
    }

    @Override
    public <T extends Named> T named(Class<T> type, String name) {
        return this.namedObjectInstantiator.named(type, name);
    }

    @Override
    public <T> T newInstance(Class<? extends T> type, Object ... parameters) throws ObjectInstantiationException {
        return this.instantiator.newInstance(type, parameters);
    }

    @Override
    public <T> Property<T> property(Class<T> valueType) {
        return this.providerFactory.propertyNoNag(valueType);
    }

    @Override
    public <T> ListProperty<T> listProperty(Class<T> elementType) {
        return new DefaultListProperty<T>(elementType);
    }

    @Override
    public <T> SetProperty<T> setProperty(Class<T> elementType) {
        return new DefaultSetProperty<T>(elementType);
    }
}

