/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.loadercache;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classloader.ClasspathHasher;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.HashingClassLoaderFactory;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.HashMultiset;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Multiset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultClassLoaderCache
implements ClassLoaderCache,
Stoppable {
    private static final Logger LOGGER = Logging.getLogger(DefaultClassLoaderCache.class);
    private final Object lock = new Object();
    private final Map<ClassLoaderId, CachedClassLoader> byId = Maps.newHashMap();
    private final Map<ClassLoaderSpec, CachedClassLoader> bySpec = Maps.newHashMap();
    private final ClasspathHasher classpathHasher;
    private final HashingClassLoaderFactory classLoaderFactory;

    public DefaultClassLoaderCache(HashingClassLoaderFactory classLoaderFactory, ClasspathHasher classpathHasher) {
        this.classLoaderFactory = classLoaderFactory;
        this.classpathHasher = classpathHasher;
    }

    @Override
    public ClassLoader get(ClassLoaderId id, ClassPath classPath, @Nullable ClassLoader parent, @Nullable FilteringClassLoader.Spec filterSpec) {
        return this.get(id, classPath, parent, filterSpec, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassLoader get(ClassLoaderId id, ClassPath classPath, @Nullable ClassLoader parent, @Nullable FilteringClassLoader.Spec filterSpec, HashCode implementationHash) {
        if (implementationHash == null) {
            implementationHash = this.classpathHasher.hash(classPath);
        }
        ManagedClassLoaderSpec spec = new ManagedClassLoaderSpec(parent, classPath, implementationHash, filterSpec);
        Object object = this.lock;
        synchronized (object) {
            CachedClassLoader cachedLoader = this.byId.get(id);
            if (cachedLoader == null || !cachedLoader.is(spec)) {
                CachedClassLoader newLoader = this.getAndRetainLoader(classPath, spec, id);
                this.byId.put(id, newLoader);
                if (cachedLoader != null) {
                    LOGGER.debug("Releasing previous classloader for {}", id);
                    cachedLoader.release(id);
                }
                return newLoader.classLoader;
            }
            return cachedLoader.classLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ClassLoader> T put(ClassLoaderId id, T classLoader) {
        Object object = this.lock;
        synchronized (object) {
            this.remove(id);
            UnmanagedClassLoaderSpec spec = new UnmanagedClassLoaderSpec(classLoader);
            CachedClassLoader cachedClassLoader = new CachedClassLoader(classLoader, spec, null);
            cachedClassLoader.retain(id);
            this.byId.put(id, cachedClassLoader);
            this.bySpec.put(spec, cachedClassLoader);
        }
        return classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(ClassLoaderId id) {
        Object object = this.lock;
        synchronized (object) {
            CachedClassLoader cachedClassLoader = this.byId.remove(id);
            if (cachedClassLoader != null) {
                cachedClassLoader.release(id);
            }
        }
    }

    private CachedClassLoader getAndRetainLoader(ClassPath classPath, ManagedClassLoaderSpec spec, ClassLoaderId id) {
        CachedClassLoader cachedLoader = this.bySpec.get(spec);
        if (cachedLoader == null) {
            ClassLoader classLoader;
            CachedClassLoader parentCachedLoader = null;
            if (spec.isFiltered()) {
                parentCachedLoader = this.getAndRetainLoader(classPath, spec.unfiltered(), id);
                classLoader = this.classLoaderFactory.createFilteringClassLoader(parentCachedLoader.classLoader, spec.filterSpec);
            } else {
                classLoader = this.classLoaderFactory.createChildClassLoader(spec.parent, classPath, spec.implementationHash);
            }
            cachedLoader = new CachedClassLoader(classLoader, spec, parentCachedLoader);
            this.bySpec.put(spec, cachedLoader);
        }
        return cachedLoader.retain(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.bySpec.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            for (CachedClassLoader cachedClassLoader : this.byId.values()) {
                ClassLoaderUtils.tryClose(cachedClassLoader.classLoader);
            }
            this.byId.clear();
            this.bySpec.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertInternalIntegrity() {
        Object object = this.lock;
        synchronized (object) {
            HashMap orphaned = Maps.newHashMap();
            for (Map.Entry<ClassLoaderId, CachedClassLoader> entry : this.byId.entrySet()) {
                if (this.bySpec.containsKey(entry.getValue().spec)) continue;
                orphaned.put(entry.getKey(), entry.getValue());
            }
            if (!orphaned.isEmpty()) {
                throw new IllegalStateException("The following class loaders are orphaned: " + Joiner.on((String)",").withKeyValueSeparator(":").join((Map)orphaned));
            }
        }
    }

    private class CachedClassLoader {
        private final ClassLoader classLoader;
        private final ClassLoaderSpec spec;
        private final CachedClassLoader parent;
        private final Multiset<ClassLoaderId> usedBy = HashMultiset.create();

        private CachedClassLoader(ClassLoader classLoader, @Nullable ClassLoaderSpec spec, CachedClassLoader parent) {
            this.classLoader = classLoader;
            this.spec = spec;
            this.parent = parent;
        }

        public boolean is(ClassLoaderSpec spec) {
            return this.spec.equals(spec);
        }

        public CachedClassLoader retain(ClassLoaderId loaderId) {
            this.usedBy.add((Object)loaderId);
            return this;
        }

        public void release(ClassLoaderId loaderId) {
            if (this.usedBy.isEmpty()) {
                throw new IllegalStateException("Cannot release already released classloader: " + this.classLoader);
            }
            if (this.usedBy.remove((Object)loaderId)) {
                if (this.usedBy.isEmpty()) {
                    if (this.parent != null) {
                        this.parent.release(loaderId);
                    }
                    DefaultClassLoaderCache.this.bySpec.remove(this.spec);
                }
            } else {
                throw new IllegalStateException("Classloader '" + this + "' not used by '" + loaderId + "'");
            }
        }
    }

    private static class ManagedClassLoaderSpec
    extends ClassLoaderSpec {
        private final ClassLoader parent;
        private final ClassPath classPath;
        private final HashCode implementationHash;
        private final FilteringClassLoader.Spec filterSpec;

        public ManagedClassLoaderSpec(ClassLoader parent, ClassPath classPath, HashCode implementationHash, FilteringClassLoader.Spec filterSpec) {
            this.parent = parent;
            this.classPath = classPath;
            this.implementationHash = implementationHash;
            this.filterSpec = filterSpec;
        }

        public ManagedClassLoaderSpec unfiltered() {
            return new ManagedClassLoaderSpec(this.parent, this.classPath, this.implementationHash, null);
        }

        public boolean isFiltered() {
            return this.filterSpec != null;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            ManagedClassLoaderSpec that = (ManagedClassLoaderSpec)o;
            return Objects.equal((Object)this.parent, (Object)that.parent) && this.implementationHash.equals(that.implementationHash) && this.classPath.equals(that.classPath) && Objects.equal((Object)this.filterSpec, (Object)that.filterSpec);
        }

        public int hashCode() {
            int result = this.implementationHash.hashCode();
            result = 31 * result + this.classPath.hashCode();
            result = 31 * result + (this.filterSpec != null ? this.filterSpec.hashCode() : 0);
            result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
            return result;
        }
    }

    private static class UnmanagedClassLoaderSpec
    extends ClassLoaderSpec {
        private final ClassLoader loader;

        public UnmanagedClassLoaderSpec(ClassLoader loader) {
            this.loader = loader;
        }
    }

    private static abstract class ClassLoaderSpec {
        private ClassLoaderSpec() {
        }
    }
}

