/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import groovy.lang.Closure;
import java.io.File;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.file.ContentFilterable;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.copy.ClosureBackedTransformer;
import org.gradle.api.internal.file.copy.CopySpecResolver;
import org.gradle.api.internal.file.copy.FileCopyDetailsInternal;
import org.gradle.api.internal.file.copy.FilterChain;
import org.gradle.internal.nativeintegration.filesystem.Chmod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileCopyDetails
extends AbstractFileTreeElement
implements FileVisitDetails,
FileCopyDetailsInternal {
    private final FileVisitDetails fileDetails;
    private final CopySpecResolver specResolver;
    private final FilterChain filterChain;
    private RelativePath relativePath;
    private boolean excluded;
    private Integer mode;
    private DuplicatesStrategy duplicatesStrategy;

    public DefaultFileCopyDetails(FileVisitDetails fileDetails, CopySpecResolver specResolver, Chmod chmod) {
        super(chmod);
        this.filterChain = new FilterChain(specResolver.getFilteringCharset());
        this.fileDetails = fileDetails;
        this.specResolver = specResolver;
        this.duplicatesStrategy = specResolver.getDuplicatesStrategy();
    }

    @Override
    public boolean isIncludeEmptyDirs() {
        return this.specResolver.getIncludeEmptyDirs();
    }

    @Override
    public String getDisplayName() {
        return this.fileDetails.toString();
    }

    @Override
    public void stopVisiting() {
        this.fileDetails.stopVisiting();
    }

    @Override
    public File getFile() {
        if (this.filterChain.hasFilters()) {
            throw new UnsupportedOperationException();
        }
        return this.fileDetails.getFile();
    }

    @Override
    public boolean isDirectory() {
        return this.fileDetails.isDirectory();
    }

    @Override
    public long getLastModified() {
        return this.fileDetails.getLastModified();
    }

    @Override
    public long getSize() {
        if (this.filterChain.hasFilters()) {
            ByteCountingOutputStream outputStream = new ByteCountingOutputStream();
            this.copyTo(outputStream);
            return outputStream.size;
        }
        return this.fileDetails.getSize();
    }

    @Override
    public InputStream open() {
        if (this.filterChain.hasFilters()) {
            return this.filterChain.transform(this.fileDetails.open());
        }
        return this.fileDetails.open();
    }

    @Override
    public void copyTo(OutputStream output) {
        if (this.filterChain.hasFilters()) {
            super.copyTo(output);
        } else {
            this.fileDetails.copyTo(output);
        }
    }

    @Override
    public boolean copyTo(File target) {
        if (this.filterChain.hasFilters()) {
            return super.copyTo(target);
        }
        boolean copied = this.fileDetails.copyTo(target);
        this.adaptPermissions(target);
        return copied;
    }

    private void adaptPermissions(File target) {
        int specMode = this.getMode();
        this.getChmod().chmod(target, specMode);
    }

    @Override
    public RelativePath getRelativePath() {
        if (this.relativePath == null) {
            RelativePath path = this.fileDetails.getRelativePath();
            this.relativePath = this.specResolver.getDestPath().append(path.isFile(), path.getSegments());
        }
        return this.relativePath;
    }

    @Override
    public int getMode() {
        if (this.mode != null) {
            return this.mode;
        }
        Integer specMode = this.getSpecMode();
        if (specMode != null) {
            return specMode;
        }
        return this.fileDetails.getMode();
    }

    @Nullable
    private Integer getSpecMode() {
        return this.fileDetails.isDirectory() ? this.specResolver.getDirMode() : this.specResolver.getFileMode();
    }

    @Override
    public void setRelativePath(RelativePath path) {
        this.relativePath = path;
    }

    @Override
    public void setName(String name) {
        this.relativePath = this.getRelativePath().replaceLastName(name);
    }

    @Override
    public void setPath(String path) {
        this.relativePath = RelativePath.parse(this.getRelativePath().isFile(), path);
    }

    boolean isExcluded() {
        return this.excluded;
    }

    @Override
    public void exclude() {
        this.excluded = true;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public ContentFilterable filter(Closure closure) {
        return this.filter(new ClosureBackedTransformer(closure));
    }

    @Override
    public ContentFilterable filter(Transformer<String, String> transformer) {
        this.filterChain.add(transformer);
        return this;
    }

    @Override
    public ContentFilterable filter(Map<String, ?> properties, Class<? extends FilterReader> filterType) {
        this.filterChain.add(filterType, properties);
        return this;
    }

    @Override
    public ContentFilterable filter(Class<? extends FilterReader> filterType) {
        this.filterChain.add(filterType);
        return this;
    }

    @Override
    public ContentFilterable expand(Map<String, ?> properties) {
        this.filterChain.expand(properties);
        return this;
    }

    @Override
    public void setDuplicatesStrategy(DuplicatesStrategy strategy) {
        this.duplicatesStrategy = strategy;
    }

    @Override
    public DuplicatesStrategy getDuplicatesStrategy() {
        return this.duplicatesStrategy;
    }

    @Override
    public String getSourceName() {
        return this.fileDetails.getName();
    }

    @Override
    public String getSourcePath() {
        return this.fileDetails.getPath();
    }

    @Override
    public RelativePath getRelativeSourcePath() {
        return this.fileDetails.getRelativePath();
    }

    private static class ByteCountingOutputStream
    extends OutputStream {
        long size;

        private ByteCountingOutputStream() {
        }

        public void write(int b) throws IOException {
            ++this.size;
        }

        public void write(byte[] b) throws IOException {
            this.size += (long)b.length;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.size += (long)len;
        }
    }
}

