/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import groovy.lang.Closure;
import java.io.File;
import java.io.FilterReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NonExtensible;
import org.gradle.api.Transformer;
import org.gradle.api.file.CopyProcessingSpec;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.ChainingTransformer;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.copy.ClosureBackedTransformer;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.CopySpecResolver;
import org.gradle.api.internal.file.copy.CopySpecSource;
import org.gradle.api.internal.file.copy.CopySpecWrapper;
import org.gradle.api.internal.file.copy.MatchingCopyAction;
import org.gradle.api.internal.file.copy.PathNotationConverter;
import org.gradle.api.internal.file.copy.RegExpNameMapper;
import org.gradle.api.internal.file.copy.RenamingCopyAction;
import org.gradle.api.internal.file.copy.SingleParentCopySpec;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonExtensible
public class DefaultCopySpec
implements CopySpecInternal {
    private static final NotationParser<Object, String> PATH_NOTATION_PARSER = PathNotationConverter.parser();
    protected final FileResolver fileResolver;
    private final Set<Object> sourcePaths = new LinkedHashSet<Object>();
    private Object destDir;
    private final PatternSet patternSet;
    private final List<CopySpecInternal> childSpecs = new LinkedList<CopySpecInternal>();
    private final List<CopySpecInternal> childSpecsInAdditionOrder = new LinkedList<CopySpecInternal>();
    protected final Instantiator instantiator;
    private final List<Action<? super FileCopyDetails>> copyActions = new LinkedList<Action<? super FileCopyDetails>>();
    private boolean hasCustomActions;
    private Integer dirMode;
    private Integer fileMode;
    private Boolean caseSensitive;
    private Boolean includeEmptyDirs;
    private DuplicatesStrategy duplicatesStrategy;
    private String filteringCharset;
    private final List<CopySpecInternal.CopySpecListener> listeners = Lists.newLinkedList();

    public DefaultCopySpec(FileResolver resolver, Instantiator instantiator) {
        this.fileResolver = resolver;
        this.instantiator = instantiator;
        PatternSet patternSet = resolver.getPatternSetFactory().create();
        assert (patternSet != null);
        this.patternSet = patternSet;
    }

    @Override
    public boolean hasCustomActions() {
        if (this.hasCustomActions) {
            return true;
        }
        for (CopySpecInternal childSpec : this.childSpecs) {
            if (!childSpec.hasCustomActions()) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    List<Action<? super FileCopyDetails>> getCopyActions() {
        return this.copyActions;
    }

    @Override
    public CopySpec with(CopySpec ... copySpecs) {
        for (CopySpec copySpec : copySpecs) {
            CopySpecInternal copySpecInternal;
            if (copySpec instanceof CopySpecSource) {
                CopySpecSource copySpecSource = (CopySpecSource)((Object)copySpec);
                copySpecInternal = copySpecSource.getRootSpec();
            } else {
                copySpecInternal = (CopySpecInternal)copySpec;
            }
            this.addChildSpec(copySpecInternal);
        }
        return this;
    }

    @Override
    public CopySpec from(Object ... sourcePaths) {
        Collections.addAll(this.sourcePaths, sourcePaths);
        return this;
    }

    @Override
    public CopySpec from(Object sourcePath, Closure c) {
        return this.from(sourcePath, (Action)new ClosureBackedAction(c));
    }

    @Override
    public CopySpec from(Object sourcePath, Action<? super CopySpec> configureAction) {
        if (configureAction == null) {
            DeprecationLogger.nagUserOfDeprecatedBehaviour("Gradle does not allow passing null for the configuration action for CopySpec.from()");
            this.from(sourcePath);
            return this;
        }
        CopySpecInternal child = this.addChild();
        child.from(sourcePath);
        CopySpecWrapper wrapper = this.instantiator.newInstance(CopySpecWrapper.class, child);
        configureAction.execute(wrapper);
        return wrapper;
    }

    @Override
    public CopySpecInternal addFirst() {
        return this.addChildAtPosition(0);
    }

    protected CopySpecInternal addChildAtPosition(int position) {
        DefaultCopySpec child = this.instantiator.newInstance(SingleParentCopySpec.class, this.fileResolver, this.instantiator, this.buildRootResolver());
        this.addChildSpec(position, child);
        return child;
    }

    @Override
    public CopySpecInternal addChild() {
        SingleParentCopySpec child = new SingleParentCopySpec(this.fileResolver, this.instantiator, this.buildRootResolver());
        this.addChildSpec(child);
        return child;
    }

    @Override
    public CopySpecInternal addChildBeforeSpec(CopySpecInternal childSpec) {
        int position = this.childSpecs.indexOf(childSpec);
        return position != -1 ? this.addChildAtPosition(position) : this.addChild();
    }

    protected void addChildSpec(CopySpecInternal childSpec) {
        this.addChildSpec(this.childSpecs.size(), childSpec);
    }

    protected void addChildSpec(int index, CopySpecInternal childSpec) {
        this.childSpecs.add(index, childSpec);
        final int additionIndex = this.childSpecsInAdditionOrder.size();
        this.childSpecsInAdditionOrder.add(childSpec);
        childSpec.addChildSpecListener(new CopySpecInternal.CopySpecListener(){

            public void childSpecAdded(CopySpecInternal.CopySpecAddress path, CopySpecInternal spec) {
                DefaultCopySpecAddress childPath = new DefaultCopySpecAddress(null, DefaultCopySpec.this, additionIndex).append(path);
                DefaultCopySpec.this.fireChildSpecListeners(childPath, spec);
            }
        });
        childSpec.visit(new DefaultCopySpecAddress(null, this, additionIndex), new CopySpecInternal.CopySpecVisitor(){

            public void visit(CopySpecInternal.CopySpecAddress parentPath, CopySpecInternal spec) {
                DefaultCopySpec.this.fireChildSpecListeners(parentPath, spec);
            }
        });
    }

    private void fireChildSpecListeners(CopySpecInternal.CopySpecAddress path, CopySpecInternal spec) {
        for (CopySpecInternal.CopySpecListener listener : this.listeners) {
            listener.childSpecAdded(path, spec);
        }
    }

    @Override
    public void visit(CopySpecInternal.CopySpecAddress parentPath, CopySpecInternal.CopySpecVisitor visitor) {
        visitor.visit(parentPath, this);
        int childIndex = 0;
        for (CopySpecInternal childSpec : this.childSpecsInAdditionOrder) {
            CopySpecInternal.CopySpecAddress childPath = parentPath.append(this, childIndex);
            childSpec.visit(childPath, visitor);
            ++childIndex;
        }
    }

    @Override
    public void addChildSpecListener(CopySpecInternal.CopySpecListener copySpecListener) {
        this.listeners.add(copySpecListener);
    }

    @VisibleForTesting
    public Set<Object> getSourcePaths() {
        return this.sourcePaths;
    }

    @Override
    public CopySpec into(Object destDir) {
        this.destDir = destDir;
        return this;
    }

    @Override
    public CopySpec into(Object destPath, Closure configureClosure) {
        return this.into(destPath, new ClosureBackedAction(configureClosure));
    }

    @Override
    public CopySpec into(Object destPath, Action<? super CopySpec> copySpec) {
        if (copySpec == null) {
            DeprecationLogger.nagUserOfDeprecatedBehaviour("Gradle does not allow passing null for the configuration action for CopySpec.into()");
            this.into(destPath);
            return this;
        }
        CopySpecInternal child = this.addChild();
        child.into(destPath);
        CopySpecWrapper wrapper = this.instantiator.newInstance(CopySpecWrapper.class, child);
        copySpec.execute(wrapper);
        return wrapper;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.buildRootResolver().isCaseSensitive();
    }

    @Override
    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public boolean getIncludeEmptyDirs() {
        return this.buildRootResolver().getIncludeEmptyDirs();
    }

    @Override
    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.includeEmptyDirs = includeEmptyDirs;
    }

    @Override
    public DuplicatesStrategy getDuplicatesStrategy() {
        return this.buildRootResolver().getDuplicatesStrategy();
    }

    @Override
    public void setDuplicatesStrategy(@Nullable DuplicatesStrategy strategy) {
        this.duplicatesStrategy = strategy;
    }

    @Override
    public CopySpec filesMatching(String pattern, Action<? super FileCopyDetails> action) {
        Spec<RelativePath> matcher = PatternMatcherFactory.getPatternMatcher(true, this.isCaseSensitive(), pattern);
        return this.eachFile((Action)new MatchingCopyAction(matcher, action));
    }

    @Override
    public CopySpec filesMatching(Iterable<String> patterns, Action<? super FileCopyDetails> action) {
        if (!patterns.iterator().hasNext()) {
            throw new InvalidUserDataException("must provide at least one pattern to match");
        }
        ArrayList<Spec<RelativePath>> matchers = new ArrayList<Spec<RelativePath>>();
        for (String pattern : patterns) {
            matchers.add(PatternMatcherFactory.getPatternMatcher(true, this.isCaseSensitive(), pattern));
        }
        return this.eachFile((Action)new MatchingCopyAction(Specs.union(matchers), action));
    }

    @Override
    public CopySpec filesNotMatching(String pattern, Action<? super FileCopyDetails> action) {
        Spec<RelativePath> matcher = PatternMatcherFactory.getPatternMatcher(true, this.isCaseSensitive(), pattern);
        return this.eachFile((Action)new MatchingCopyAction(Specs.negate(matcher), action));
    }

    @Override
    public CopySpec filesNotMatching(Iterable<String> patterns, Action<? super FileCopyDetails> action) {
        if (!patterns.iterator().hasNext()) {
            throw new InvalidUserDataException("must provide at least one pattern to not match");
        }
        ArrayList<Spec<RelativePath>> matchers = new ArrayList<Spec<RelativePath>>();
        for (String pattern : patterns) {
            matchers.add(PatternMatcherFactory.getPatternMatcher(true, this.isCaseSensitive(), pattern));
        }
        return this.eachFile((Action)new MatchingCopyAction(Specs.negate(Specs.union(matchers)), action));
    }

    @Override
    public CopySpec include(String ... includes) {
        this.patternSet.include(includes);
        return this;
    }

    @Override
    public CopySpec include(Iterable<String> includes) {
        this.patternSet.include((Iterable)includes);
        return this;
    }

    @Override
    public CopySpec include(Spec<FileTreeElement> includeSpec) {
        this.patternSet.include((Spec)includeSpec);
        return this;
    }

    @Override
    public CopySpec include(Closure includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    @Override
    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    @Override
    public CopySpec setIncludes(Iterable<String> includes) {
        this.patternSet.setIncludes((Iterable)includes);
        return this;
    }

    @Override
    public CopySpec exclude(String ... excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    @Override
    public CopySpec exclude(Iterable<String> excludes) {
        this.patternSet.exclude((Iterable)excludes);
        return this;
    }

    @Override
    public CopySpec exclude(Spec<FileTreeElement> excludeSpec) {
        this.patternSet.exclude((Spec)excludeSpec);
        return this;
    }

    @Override
    public CopySpec exclude(Closure excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    @Override
    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    @Override
    public CopySpec setExcludes(Iterable<String> excludes) {
        this.patternSet.setExcludes((Iterable)excludes);
        return this;
    }

    @Override
    public CopySpec rename(String sourceRegEx, String replaceWith) {
        this.appendCopyAction(new RenamingCopyAction(new RegExpNameMapper(sourceRegEx, replaceWith)));
        return this;
    }

    @Override
    public CopySpec rename(Pattern sourceRegEx, String replaceWith) {
        this.appendCopyAction(new RenamingCopyAction(new RegExpNameMapper(sourceRegEx, replaceWith)));
        return this;
    }

    @Override
    public CopySpec filter(final Class<? extends FilterReader> filterType) {
        this.appendCopyAction((Action<? super FileCopyDetails>)new Action<FileCopyDetails>(){

            @Override
            public void execute(FileCopyDetails fileCopyDetails) {
                fileCopyDetails.filter(filterType);
            }
        });
        return this;
    }

    @Override
    public CopySpec filter(Closure closure) {
        return this.filter((Transformer)new ClosureBackedTransformer(closure));
    }

    @Override
    public CopySpec filter(final Transformer<String, String> transformer) {
        this.appendCopyAction((Action<? super FileCopyDetails>)new Action<FileCopyDetails>(){

            @Override
            public void execute(FileCopyDetails fileCopyDetails) {
                fileCopyDetails.filter(transformer);
            }
        });
        return this;
    }

    @Override
    public CopySpec filter(final Map<String, ?> properties, final Class<? extends FilterReader> filterType) {
        this.appendCopyAction((Action<? super FileCopyDetails>)new Action<FileCopyDetails>(){

            @Override
            public void execute(FileCopyDetails fileCopyDetails) {
                fileCopyDetails.filter(properties, filterType);
            }
        });
        return this;
    }

    @Override
    public CopySpec expand(final Map<String, ?> properties) {
        this.appendCopyAction((Action<? super FileCopyDetails>)new Action<FileCopyDetails>(){

            @Override
            public void execute(FileCopyDetails fileCopyDetails) {
                fileCopyDetails.expand(properties);
            }
        });
        return this;
    }

    @Override
    public CopySpec rename(Closure closure) {
        return this.rename((Transformer)new ClosureBackedTransformer(closure));
    }

    @Override
    public CopySpec rename(Transformer<String, String> renamer) {
        ChainingTransformer<String> transformer = new ChainingTransformer<String>(String.class);
        transformer.add(renamer);
        this.appendCopyAction(new RenamingCopyAction(transformer));
        return this;
    }

    @Override
    public Integer getDirMode() {
        return this.buildRootResolver().getDirMode();
    }

    @Override
    public Integer getFileMode() {
        return this.buildRootResolver().getFileMode();
    }

    @Override
    public CopyProcessingSpec setDirMode(@Nullable Integer mode) {
        this.dirMode = mode;
        return this;
    }

    @Override
    public CopyProcessingSpec setFileMode(@Nullable Integer mode) {
        this.fileMode = mode;
        return this;
    }

    @Override
    public CopySpec eachFile(Action<? super FileCopyDetails> action) {
        this.appendCopyAction(action);
        return this;
    }

    private void appendCopyAction(Action<? super FileCopyDetails> action) {
        this.hasCustomActions = true;
        this.copyActions.add(action);
    }

    @Override
    public void appendCachingSafeCopyAction(Action<? super FileCopyDetails> action) {
        this.copyActions.add(action);
    }

    @Override
    public CopySpec eachFile(Closure closure) {
        this.appendCopyAction(ConfigureUtil.configureUsing(closure));
        return this;
    }

    @Override
    public Iterable<CopySpecInternal> getChildren() {
        return this.childSpecs;
    }

    @Override
    public void walk(Action<? super CopySpecResolver> action) {
        this.buildRootResolver().walk(action);
    }

    @Override
    public CopySpecResolver buildResolverRelativeToParent(CopySpecResolver parent) {
        return new DefaultCopySpecResolver(parent);
    }

    @Override
    public CopySpecResolver buildRootResolver() {
        return new DefaultCopySpecResolver(null);
    }

    @Override
    public String getFilteringCharset() {
        return this.buildRootResolver().getFilteringCharset();
    }

    @Override
    public void setFilteringCharset(String charset) {
        Preconditions.checkNotNull((Object)charset, (Object)"filteringCharset must not be null");
        if (!Charset.isSupported(charset)) {
            throw new InvalidUserDataException(String.format("filteringCharset %s is not supported by your JVM", charset));
        }
        this.filteringCharset = charset;
    }

    private class DefaultCopySpecAddress
    implements CopySpecInternal.CopySpecAddress {
        private final DefaultCopySpecAddress parent;
        private final CopySpecInternal spec;
        private final int additionIndex;

        public DefaultCopySpecAddress(DefaultCopySpecAddress parent, CopySpecInternal spec, int additionIndex) {
            this.parent = parent;
            this.spec = spec;
            this.additionIndex = additionIndex;
        }

        public CopySpecInternal.CopySpecAddress getParent() {
            return this.parent;
        }

        public CopySpecInternal getSpec() {
            return this.spec;
        }

        public int getAdditionIndex() {
            return this.additionIndex;
        }

        public DefaultCopySpecAddress append(CopySpecInternal spec, int additionIndex) {
            return new DefaultCopySpecAddress(this, spec, additionIndex);
        }

        public DefaultCopySpecAddress append(CopySpecInternal.CopySpecAddress relativeAddress) {
            CopySpecInternal.CopySpecAddress parent = relativeAddress.getParent();
            DefaultCopySpecAddress newParent = parent == null ? this : this.append(parent);
            return new DefaultCopySpecAddress(newParent, relativeAddress.getSpec(), relativeAddress.getAdditionIndex());
        }

        public CopySpecResolver unroll(StringBuilder path) {
            CopySpecResolver resolver = this.parent != null ? this.spec.buildResolverRelativeToParent(this.parent.unroll(path)) : this.spec.buildRootResolver();
            path.append("$").append(this.additionIndex + 1);
            return resolver;
        }

        public String toString() {
            String parentPath = this.parent == null ? "" : this.parent.toString();
            return parentPath + "$" + (this.additionIndex + 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DefaultCopySpecResolver
    implements CopySpecResolver {
        private CopySpecResolver parentResolver;

        private DefaultCopySpecResolver(CopySpecResolver parent) {
            this.parentResolver = parent;
        }

        @Override
        public RelativePath getDestPath() {
            RelativePath parentPath = this.parentResolver == null ? new RelativePath(false, new String[0]) : this.parentResolver.getDestPath();
            if (DefaultCopySpec.this.destDir == null) {
                return parentPath;
            }
            String path = (String)PATH_NOTATION_PARSER.parseNotation(DefaultCopySpec.this.destDir);
            if (path.startsWith("/") || path.startsWith(File.separator)) {
                return RelativePath.parse(false, path);
            }
            return RelativePath.parse(false, parentPath, path);
        }

        @Override
        public FileTree getSource() {
            return DefaultCopySpec.this.fileResolver.resolveFilesAsTree(DefaultCopySpec.this.sourcePaths).matching(this.getPatternSet());
        }

        @Override
        public FileTree getAllSource() {
            final ImmutableList.Builder builder = ImmutableList.builder();
            this.walk((Action<? super CopySpecResolver>)new Action<CopySpecResolver>(){

                @Override
                public void execute(CopySpecResolver copySpecResolver) {
                    builder.add((Object)copySpecResolver.getSource());
                }
            });
            return DefaultCopySpec.this.fileResolver.compositeFileTree((List<? extends FileTree>)builder.build());
        }

        @Override
        public Collection<? extends Action<? super FileCopyDetails>> getAllCopyActions() {
            if (this.parentResolver == null) {
                return DefaultCopySpec.this.copyActions;
            }
            ArrayList<? extends Action<? super FileCopyDetails>> allActions = new ArrayList<Action<? super FileCopyDetails>>();
            allActions.addAll(this.parentResolver.getAllCopyActions());
            allActions.addAll(DefaultCopySpec.this.copyActions);
            return allActions;
        }

        @Override
        public List<String> getAllIncludes() {
            ArrayList<String> result = new ArrayList<String>();
            if (this.parentResolver != null) {
                result.addAll(this.parentResolver.getAllIncludes());
            }
            result.addAll(DefaultCopySpec.this.patternSet.getIncludes());
            return result;
        }

        @Override
        public List<String> getAllExcludes() {
            ArrayList<String> result = new ArrayList<String>();
            if (this.parentResolver != null) {
                result.addAll(this.parentResolver.getAllExcludes());
            }
            result.addAll(DefaultCopySpec.this.patternSet.getExcludes());
            return result;
        }

        @Override
        public List<Spec<FileTreeElement>> getAllExcludeSpecs() {
            ArrayList<Spec<FileTreeElement>> result = new ArrayList<Spec<FileTreeElement>>();
            if (this.parentResolver != null) {
                result.addAll(this.parentResolver.getAllExcludeSpecs());
            }
            result.addAll(DefaultCopySpec.this.patternSet.getExcludeSpecs());
            return result;
        }

        @Override
        public DuplicatesStrategy getDuplicatesStrategy() {
            if (DefaultCopySpec.this.duplicatesStrategy != null) {
                return DefaultCopySpec.this.duplicatesStrategy;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.getDuplicatesStrategy();
            }
            return DuplicatesStrategy.INCLUDE;
        }

        @Override
        public boolean isCaseSensitive() {
            if (DefaultCopySpec.this.caseSensitive != null) {
                return DefaultCopySpec.this.caseSensitive;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.isCaseSensitive();
            }
            return true;
        }

        @Override
        public Integer getFileMode() {
            if (DefaultCopySpec.this.fileMode != null) {
                return DefaultCopySpec.this.fileMode;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.getFileMode();
            }
            return null;
        }

        @Override
        public Integer getDirMode() {
            if (DefaultCopySpec.this.dirMode != null) {
                return DefaultCopySpec.this.dirMode;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.getDirMode();
            }
            return null;
        }

        @Override
        public boolean getIncludeEmptyDirs() {
            if (DefaultCopySpec.this.includeEmptyDirs != null) {
                return DefaultCopySpec.this.includeEmptyDirs;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.getIncludeEmptyDirs();
            }
            return true;
        }

        @Override
        public List<Spec<FileTreeElement>> getAllIncludeSpecs() {
            ArrayList<Spec<FileTreeElement>> result = new ArrayList<Spec<FileTreeElement>>();
            if (this.parentResolver != null) {
                result.addAll(this.parentResolver.getAllIncludeSpecs());
            }
            result.addAll(DefaultCopySpec.this.patternSet.getIncludeSpecs());
            return result;
        }

        public PatternSet getPatternSet() {
            PatternSet patterns = DefaultCopySpec.this.fileResolver.getPatternSetFactory().create();
            assert (patterns != null);
            patterns.setCaseSensitive(this.isCaseSensitive());
            patterns.include(this.getAllIncludes());
            patterns.includeSpecs(this.getAllIncludeSpecs());
            patterns.exclude(this.getAllExcludes());
            patterns.excludeSpecs(this.getAllExcludeSpecs());
            return patterns;
        }

        @Override
        public void walk(Action<? super CopySpecResolver> action) {
            action.execute(this);
            for (CopySpecInternal child : DefaultCopySpec.this.getChildren()) {
                child.buildResolverRelativeToParent(this).walk(action);
            }
        }

        @Override
        public String getFilteringCharset() {
            if (DefaultCopySpec.this.filteringCharset != null) {
                return DefaultCopySpec.this.filteringCharset;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.getFilteringCharset();
            }
            return Charset.defaultCharset().name();
        }
    }
}

