/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import java.util.List;
import java.util.ListIterator;
import org.gradle.api.Action;
import org.gradle.api.internal.collections.PendingSource;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPendingSource<T>
implements PendingSource<T> {
    private final List<ProviderInternal<? extends T>> pending = Lists.newArrayList();
    private Action<ProviderInternal<? extends T>> flushAction;

    @Override
    public void realizePending() {
        for (ProviderInternal<? extends T> providerInternal : this.pending) {
            if (this.flushAction != null) {
                this.flushAction.execute(providerInternal);
                continue;
            }
            throw new IllegalStateException("Cannot realize pending elements when realize action is not set");
        }
        this.pending.clear();
    }

    @Override
    public void realizePending(Class<?> type) {
        ListIterator<ProviderInternal<T>> iterator = this.pending.listIterator();
        while (iterator.hasNext()) {
            ProviderInternal<T> provider = iterator.next();
            if (provider.getType() != null && !type.isAssignableFrom(provider.getType())) continue;
            this.flushAction.execute(provider);
            iterator.remove();
        }
    }

    @Override
    public void addPending(ProviderInternal<? extends T> provider) {
        this.pending.add(provider);
    }

    @Override
    public void removePending(ProviderInternal<? extends T> provider) {
        this.pending.remove(provider);
    }

    @Override
    public void onRealize(Action<ProviderInternal<? extends T>> action) {
        this.flushAction = action;
    }

    @Override
    public boolean isEmpty() {
        return this.pending.isEmpty();
    }

    @Override
    public int size() {
        return this.pending.size();
    }

    @Override
    public void clear() {
        this.pending.clear();
    }
}

