/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Named;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.changedetection.state.ArrayValueSnapshot;
import org.gradle.api.internal.changedetection.state.BooleanValueSnapshot;
import org.gradle.api.internal.changedetection.state.EnumValueSnapshot;
import org.gradle.api.internal.changedetection.state.FileValueSnapshot;
import org.gradle.api.internal.changedetection.state.ImplementationSnapshot;
import org.gradle.api.internal.changedetection.state.IntegerValueSnapshot;
import org.gradle.api.internal.changedetection.state.IsolatedManagedNamedTypeSnapshot;
import org.gradle.api.internal.changedetection.state.ListValueSnapshot;
import org.gradle.api.internal.changedetection.state.LongValueSnapshot;
import org.gradle.api.internal.changedetection.state.ManagedNamedTypeSnapshot;
import org.gradle.api.internal.changedetection.state.MapValueSnapshot;
import org.gradle.api.internal.changedetection.state.NullValueSnapshot;
import org.gradle.api.internal.changedetection.state.ProviderSnapshot;
import org.gradle.api.internal.changedetection.state.SerializedValueSnapshot;
import org.gradle.api.internal.changedetection.state.SetValueSnapshot;
import org.gradle.api.internal.changedetection.state.ShortValueSnapshot;
import org.gradle.api.internal.changedetection.state.StringValueSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshotStrategy;
import org.gradle.api.internal.changedetection.state.isolation.Isolatable;
import org.gradle.api.internal.changedetection.state.isolation.IsolatableEnumValueSnapshot;
import org.gradle.api.internal.changedetection.state.isolation.IsolatableFactory;
import org.gradle.api.internal.changedetection.state.isolation.IsolatableSerializedValueSnapshot;
import org.gradle.api.internal.changedetection.state.isolation.IsolatableValueSnapshotStrategy;
import org.gradle.api.internal.changedetection.state.isolation.IsolationException;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueSnapshotter
implements IsolatableFactory {
    private final ClassLoaderHierarchyHasher classLoaderHasher;
    private final NamedObjectInstantiator namedObjectInstantiator;
    private final ValueSnapshotStrategy valueSnapshotStrategy;
    private final IsolatableValueSnapshotStrategy isolatedSnapshotStrategy;

    public ValueSnapshotter(ClassLoaderHierarchyHasher classLoaderHasher, NamedObjectInstantiator namedObjectInstantiator) {
        this.classLoaderHasher = classLoaderHasher;
        this.namedObjectInstantiator = namedObjectInstantiator;
        this.valueSnapshotStrategy = new ValueSnapshotStrategy(this);
        this.isolatedSnapshotStrategy = new IsolatableValueSnapshotStrategy(this);
    }

    public ValueSnapshot snapshot(Object value) throws UncheckedIOException {
        return this.processValue(value, this.valueSnapshotStrategy);
    }

    @Override
    public <T> Isolatable<T> isolate(T value) {
        try {
            return (Isolatable)Cast.uncheckedCast(this.isolatableSnapshot(value));
        }
        catch (Throwable t) {
            throw new IsolationException(value, t);
        }
    }

    public ValueSnapshot isolatableSnapshot(Object value) throws UncheckedIOException {
        ValueSnapshot possible = this.processValue(value, this.isolatedSnapshotStrategy);
        if (possible instanceof Isolatable) {
            return possible;
        }
        return this.wrap(value, possible);
    }

    private ValueSnapshot processValue(Object value, ValueSnapshotStrategy strategy) {
        if (value == null) {
            return NullValueSnapshot.INSTANCE;
        }
        if (value instanceof String) {
            return new StringValueSnapshot((String)value);
        }
        if (value instanceof Boolean) {
            return value.equals(Boolean.TRUE) ? BooleanValueSnapshot.TRUE : BooleanValueSnapshot.FALSE;
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() == 0) {
                return ListValueSnapshot.EMPTY;
            }
            ValueSnapshot[] elements = new ValueSnapshot[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Object element = list.get(i);
                elements[i] = strategy.snapshot(element);
            }
            return new ListValueSnapshot(elements);
        }
        if (value instanceof Enum) {
            return new EnumValueSnapshot((Enum)value);
        }
        if (value instanceof Class) {
            Class implementation = (Class)value;
            return new ImplementationSnapshot(implementation.getName(), this.classLoaderHasher.getClassLoaderHash(implementation.getClassLoader()));
        }
        if (value.getClass().equals(File.class)) {
            return new FileValueSnapshot((File)value);
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return new IntegerValueSnapshot((Integer)value);
            }
            if (value instanceof Long) {
                return new LongValueSnapshot((Long)value);
            }
            if (value instanceof Short) {
                return new ShortValueSnapshot((Short)value);
            }
        }
        if (value instanceof Set) {
            Set set = (Set)value;
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Object element : set) {
                builder.add((Object)strategy.snapshot(element));
            }
            return new SetValueSnapshot((ImmutableSet<ValueSnapshot>)builder.build());
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Map.Entry entry : map.entrySet()) {
                builder.put((Object)strategy.snapshot(entry.getKey()), (Object)strategy.snapshot(entry.getValue()));
            }
            return new MapValueSnapshot((ImmutableMap<ValueSnapshot, ValueSnapshot>)builder.build());
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            if (length == 0) {
                return ArrayValueSnapshot.EMPTY;
            }
            ValueSnapshot[] elements = new ValueSnapshot[length];
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(value, i);
                elements[i] = strategy.snapshot(element);
            }
            return new ArrayValueSnapshot(elements);
        }
        if (value instanceof Provider) {
            Provider provider = (Provider)value;
            ValueSnapshot valueSnapshot = strategy.snapshot(provider.get());
            return new ProviderSnapshot(valueSnapshot);
        }
        if (value instanceof NamedObjectInstantiator.Managed) {
            return new ManagedNamedTypeSnapshot((Named)value);
        }
        return this.serialize(value);
    }

    private SerializedValueSnapshot serialize(Object value) {
        ByteArrayOutputStream outputStream;
        try {
            outputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectStr = new ObjectOutputStream(outputStream);
            objectStr.writeObject(value);
            objectStr.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new SerializedValueSnapshot(this.classLoaderHasher.getClassLoaderHash(value.getClass().getClassLoader()), outputStream.toByteArray());
    }

    private ValueSnapshot wrap(Object value, ValueSnapshot possible) {
        if (possible instanceof EnumValueSnapshot) {
            return new IsolatableEnumValueSnapshot((Enum)value);
        }
        if (possible instanceof SerializedValueSnapshot) {
            SerializedValueSnapshot original = (SerializedValueSnapshot)possible;
            return new IsolatableSerializedValueSnapshot(original.getImplementationHash(), original.getValue(), value.getClass());
        }
        if (possible instanceof ManagedNamedTypeSnapshot) {
            return new IsolatedManagedNamedTypeSnapshot((Named)value, this.namedObjectInstantiator);
        }
        throw new IsolationException(value);
    }

    public ValueSnapshot snapshot(Object value, ValueSnapshot candidate) {
        return candidate.snapshot(value, this);
    }
}

