/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.IOException;
import java.util.Map;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.HistoricalTaskExecution;
import org.gradle.api.internal.changedetection.state.ImplementationSnapshot;
import org.gradle.api.internal.changedetection.state.InputPropertiesSerializer;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.api.internal.tasks.OriginTaskExecutionMetadata;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskExecutionSnapshotSerializer
extends AbstractSerializer<HistoricalTaskExecution> {
    private final InputPropertiesSerializer inputPropertiesSerializer;
    private final StringInterner stringInterner;
    private final Serializer<FileCollectionSnapshot> fileCollectionSnapshotSerializer;

    TaskExecutionSnapshotSerializer(StringInterner stringInterner, Serializer<FileCollectionSnapshot> fileCollectionSnapshotSerializer) {
        this.fileCollectionSnapshotSerializer = fileCollectionSnapshotSerializer;
        this.inputPropertiesSerializer = new InputPropertiesSerializer();
        this.stringInterner = stringInterner;
    }

    @Override
    public HistoricalTaskExecution read(Decoder decoder) throws Exception {
        boolean successful = decoder.readBoolean();
        OriginTaskExecutionMetadata originExecutionMetadata = new OriginTaskExecutionMetadata(UniqueId.from(decoder.readString()), decoder.readLong());
        ImmutableSortedMap<String, FileCollectionSnapshot> inputFilesSnapshots = this.readSnapshots(decoder);
        ImmutableSortedMap<String, FileCollectionSnapshot> outputFilesSnapshots = this.readSnapshots(decoder);
        FileCollectionSnapshot discoveredFilesSnapshot = this.fileCollectionSnapshotSerializer.read(decoder);
        ImplementationSnapshot taskImplementation = TaskExecutionSnapshotSerializer.readImplementation(decoder);
        int taskActionsCount = decoder.readSmallInt();
        ImmutableList.Builder taskActionImplementationsBuilder = ImmutableList.builder();
        for (int j = 0; j < taskActionsCount; ++j) {
            ImplementationSnapshot actionImpl = TaskExecutionSnapshotSerializer.readImplementation(decoder);
            taskActionImplementationsBuilder.add((Object)actionImpl);
        }
        ImmutableList taskActionImplementations = taskActionImplementationsBuilder.build();
        int cacheableOutputPropertiesCount = decoder.readSmallInt();
        ImmutableSortedSet.Builder cacheableOutputPropertiesBuilder = ImmutableSortedSet.naturalOrder();
        for (int j = 0; j < cacheableOutputPropertiesCount; ++j) {
            cacheableOutputPropertiesBuilder.add((Object)decoder.readString());
        }
        ImmutableSortedSet cacheableOutputProperties = cacheableOutputPropertiesBuilder.build();
        ImmutableSortedMap<String, ValueSnapshot> inputProperties = this.inputPropertiesSerializer.read(decoder);
        return new HistoricalTaskExecution(taskImplementation, (ImmutableList<ImplementationSnapshot>)taskActionImplementations, inputProperties, (ImmutableSortedSet<String>)cacheableOutputProperties, inputFilesSnapshots, discoveredFilesSnapshot, outputFilesSnapshots, successful, originExecutionMetadata);
    }

    @Override
    public void write(Encoder encoder, HistoricalTaskExecution execution) throws Exception {
        encoder.writeBoolean(execution.isSuccessful());
        encoder.writeString(execution.getOriginExecutionMetadata().getBuildInvocationId().asString());
        encoder.writeLong(execution.getOriginExecutionMetadata().getExecutionTime());
        this.writeSnapshots(encoder, (Map<String, FileCollectionSnapshot>)execution.getInputFilesSnapshot());
        this.writeSnapshots(encoder, (Map<String, FileCollectionSnapshot>)execution.getOutputFilesSnapshot());
        this.fileCollectionSnapshotSerializer.write(encoder, execution.getDiscoveredInputFilesSnapshot());
        TaskExecutionSnapshotSerializer.writeImplementation(encoder, execution.getTaskImplementation());
        encoder.writeSmallInt(execution.getTaskActionImplementations().size());
        for (ImplementationSnapshot actionImpl : execution.getTaskActionImplementations()) {
            TaskExecutionSnapshotSerializer.writeImplementation(encoder, actionImpl);
        }
        encoder.writeSmallInt(execution.getOutputPropertyNamesForCacheKey().size());
        for (String outputFile : execution.getOutputPropertyNamesForCacheKey()) {
            encoder.writeString(outputFile);
        }
        this.inputPropertiesSerializer.write(encoder, (ImmutableMap<String, ValueSnapshot>)execution.getInputProperties());
    }

    private static ImplementationSnapshot readImplementation(Decoder decoder) throws IOException {
        String typeName = decoder.readString();
        HashCode classLoaderHash = decoder.readBoolean() ? HashCode.fromBytes(decoder.readBinary()) : null;
        return new ImplementationSnapshot(typeName, classLoaderHash);
    }

    private static void writeImplementation(Encoder encoder, ImplementationSnapshot implementation) throws IOException {
        encoder.writeString(implementation.getTypeName());
        if (implementation.hasUnknownClassLoader()) {
            encoder.writeBoolean(false);
        } else {
            encoder.writeBoolean(true);
            encoder.writeBinary(implementation.getClassLoaderHash().toByteArray());
        }
    }

    private ImmutableSortedMap<String, FileCollectionSnapshot> readSnapshots(Decoder decoder) throws Exception {
        int count = decoder.readSmallInt();
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (int snapshotIdx = 0; snapshotIdx < count; ++snapshotIdx) {
            String property = decoder.readString();
            FileCollectionSnapshot snapshot = this.fileCollectionSnapshotSerializer.read(decoder);
            builder.put((Object)property, (Object)snapshot);
        }
        return builder.build();
    }

    private void writeSnapshots(Encoder encoder, Map<String, FileCollectionSnapshot> ids) throws Exception {
        encoder.writeSmallInt(ids.size());
        for (Map.Entry<String, FileCollectionSnapshot> entry : ids.entrySet()) {
            encoder.writeString(entry.getKey());
            this.fileCollectionSnapshotSerializer.write(encoder, entry.getValue());
        }
    }
}

