/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.internal.changedetection.state.CachingResourceHasher;
import org.gradle.api.internal.changedetection.state.RegularFileHasher;
import org.gradle.api.internal.changedetection.state.RegularFileSnapshot;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSnapshotterCacheService {
    private static final HashCode NO_HASH = Hashing.md5().hashString(CachingResourceHasher.class.getName() + " : no hash");
    private final PersistentIndexedCache<HashCode, HashCode> persistentCache;

    public ResourceSnapshotterCacheService(PersistentIndexedCache<HashCode, HashCode> persistentCache) {
        this.persistentCache = persistentCache;
    }

    public HashCode hashFile(RegularFileSnapshot fileSnapshot, RegularFileHasher hasher, HashCode configurationHash) {
        HashCode resourceHashCacheKey = ResourceSnapshotterCacheService.resourceHashCacheKey(fileSnapshot, configurationHash);
        HashCode resourceHash = this.persistentCache.get(resourceHashCacheKey);
        if (resourceHash != null) {
            if (resourceHash.equals(NO_HASH)) {
                return null;
            }
            return resourceHash;
        }
        resourceHash = hasher.hash(fileSnapshot);
        if (resourceHash != null) {
            this.persistentCache.put(resourceHashCacheKey, resourceHash);
        } else {
            this.persistentCache.put(resourceHashCacheKey, NO_HASH);
        }
        return resourceHash;
    }

    private static HashCode resourceHashCacheKey(RegularFileSnapshot fileSnapshot, HashCode configurationHash) {
        DefaultBuildCacheHasher hasher = new DefaultBuildCacheHasher();
        hasher.putHash(configurationHash);
        hasher.putHash(fileSnapshot.getContent().getContentMd5());
        return hasher.hash();
    }
}

