/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshotter;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.internal.hash.HashCode;

public class ImplementationSnapshot
implements ValueSnapshot {
    private final String typeName;
    private final HashCode classLoaderHash;

    public ImplementationSnapshot(String typeName, @Nullable HashCode classLoaderHash) {
        this.typeName = typeName;
        this.classLoaderHash = classLoaderHash;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public HashCode getClassLoaderHash() {
        if (this.classLoaderHash == null) {
            throw new NullPointerException("classLoaderHash");
        }
        return this.classLoaderHash;
    }

    public boolean hasUnknownClassLoader() {
        return this.classLoaderHash == null;
    }

    public void appendToHasher(BuildCacheHasher hasher) {
        if (this.classLoaderHash == null) {
            hasher.markAsInvalid();
        } else {
            hasher.putString(ImplementationSnapshot.class.getName());
            hasher.putString(this.typeName);
            hasher.putHash(this.classLoaderHash);
        }
    }

    public ValueSnapshot snapshot(Object value, ValueSnapshotter snapshotter) {
        ValueSnapshot other = snapshotter.snapshot(value);
        if (this.isSameSnapshot(other)) {
            return this;
        }
        return other;
    }

    private boolean isSameSnapshot(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImplementationSnapshot that = (ImplementationSnapshot)o;
        if (!this.typeName.equals(that.typeName)) {
            return false;
        }
        return this.classLoaderHash != null ? this.classLoaderHash.equals(that.classLoaderHash) : that.classLoaderHash == null;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImplementationSnapshot that = (ImplementationSnapshot)o;
        if (this.classLoaderHash == null || that.classLoaderHash == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!this.typeName.equals(that.typeName)) {
            return false;
        }
        return this.classLoaderHash.equals(that.classLoaderHash);
    }

    public int hashCode() {
        int result = this.typeName.hashCode();
        result = 31 * result + (this.classLoaderHash != null ? this.classLoaderHash.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.typeName + "@" + this.classLoaderHash;
    }
}

