/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.internal.changedetection.state.FileContentSnapshot;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.base.Objects;

public class FileHashSnapshot
implements FileContentSnapshot {
    private final HashCode hash;
    private final transient long lastModified;

    public FileHashSnapshot(HashCode hash) {
        this(hash, 0L);
    }

    public FileHashSnapshot(HashCode hash, long lastModified) {
        this.hash = hash;
        this.lastModified = lastModified;
    }

    public boolean isContentUpToDate(FileContentSnapshot snapshot) {
        if (!(snapshot instanceof FileHashSnapshot)) {
            return false;
        }
        FileHashSnapshot other = (FileHashSnapshot)snapshot;
        return Objects.equal((Object)this.hash, (Object)other.hash);
    }

    public boolean isContentAndMetadataUpToDate(FileContentSnapshot snapshot) {
        if (!(snapshot instanceof FileHashSnapshot)) {
            return false;
        }
        FileHashSnapshot other = (FileHashSnapshot)snapshot;
        return this.lastModified == other.lastModified && Objects.equal((Object)this.hash, (Object)other.hash);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileHashSnapshot that = (FileHashSnapshot)o;
        return Objects.equal((Object)this.hash, (Object)that.hash);
    }

    public int hashCode() {
        return this.hash.hashCode();
    }

    public String toString() {
        return this.hash.toString();
    }

    public FileType getType() {
        return FileType.RegularFile;
    }

    public HashCode getContentMd5() {
        return this.hash;
    }
}

