/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.gradle.api.internal.changedetection.rules.FileChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileContentSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.Iterators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmptyFileCollectionSnapshot
implements FileCollectionSnapshot {
    public static final EmptyFileCollectionSnapshot INSTANCE = new EmptyFileCollectionSnapshot();
    private static final HashCode SIGNATURE = Hashing.md5().hashString(EmptyFileCollectionSnapshot.class.getName());

    private EmptyFileCollectionSnapshot() {
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Iterator<TaskStateChange> iterateContentChangesSince(FileCollectionSnapshot oldSnapshot, final String title, boolean includeAdded) {
        return Iterators.transform(oldSnapshot.getContentSnapshots().entrySet().iterator(), (Function)new Function<Map.Entry<String, FileContentSnapshot>, TaskStateChange>(){

            public TaskStateChange apply(Map.Entry<String, FileContentSnapshot> entry) {
                return FileChange.removed(entry.getKey(), title, entry.getValue().getType());
            }
        });
    }

    @Override
    public HashCode getHash() {
        return SIGNATURE;
    }

    @Override
    public Collection<File> getElements() {
        return Collections.emptySet();
    }

    @Override
    public Collection<File> getFiles() {
        return Collections.emptySet();
    }

    @Override
    public Map<String, NormalizedFileSnapshot> getSnapshots() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, FileContentSnapshot> getContentSnapshots() {
        return Collections.emptyMap();
    }

    @Override
    public void appendToHasher(BuildCacheHasher hasher) {
        hasher.putHash(SIGNATURE);
    }

    public String toString() {
        return "EMPTY";
    }
}

