/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import org.gradle.api.internal.changedetection.state.RegularFileSnapshot;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.ResourceSnapshotterCacheService;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.internal.hash.HashCode;

public class CachingResourceHasher
implements ResourceHasher {
    private final ResourceHasher delegate;
    private final ResourceSnapshotterCacheService resourceSnapshotterCacheService;
    private final HashCode delegateConfigurationHash;

    public CachingResourceHasher(ResourceHasher delegate, ResourceSnapshotterCacheService resourceSnapshotterCacheService) {
        this.delegate = delegate;
        this.resourceSnapshotterCacheService = resourceSnapshotterCacheService;
        DefaultBuildCacheHasher hasher = new DefaultBuildCacheHasher();
        delegate.appendConfigurationToHasher(hasher);
        this.delegateConfigurationHash = hasher.hash();
    }

    public HashCode hash(RegularFileSnapshot fileSnapshot) {
        return this.resourceSnapshotterCacheService.hashFile(fileSnapshot, this.delegate, this.delegateConfigurationHash);
    }

    public HashCode hash(ZipEntry zipEntry, InputStream zipInput) throws IOException {
        return this.delegate.hash(zipEntry, zipInput);
    }

    public void appendConfigurationToHasher(BuildCacheHasher hasher) {
        this.delegate.appendConfigurationToHasher(hasher);
    }
}

