/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import java.util.List;
import java.util.SortedMap;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.internal.changedetection.rules.DescriptiveChange;
import org.gradle.api.internal.changedetection.rules.PropertyDiffListener;
import org.gradle.api.internal.changedetection.rules.SimpleTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.SortedMapDiffUtil;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.state.TaskExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public abstract class AbstractPropertyTaskStateChanges<V>
extends SimpleTaskStateChanges {
    private final TaskExecution previous;
    private final TaskExecution current;
    private final String title;
    private final Task task;

    protected AbstractPropertyTaskStateChanges(TaskExecution previous, TaskExecution current, String title, Task task) {
        this.previous = previous;
        this.current = current;
        this.title = title;
        this.task = task;
    }

    protected abstract SortedMap<String, V> getProperties(TaskExecution var1);

    @Override
    protected void addAllChanges(final List<TaskStateChange> changes) {
        SortedMapDiffUtil.diff(this.getProperties(this.previous), this.getProperties(this.current), new PropertyDiffListener<String, V>(){

            @Override
            public void removed(String previousProperty) {
                changes.add(new DescriptiveChange("%s property '%s' has been removed for %s", AbstractPropertyTaskStateChanges.this.title, previousProperty, AbstractPropertyTaskStateChanges.this.task));
            }

            @Override
            public void added(String currentProperty) {
                changes.add(new DescriptiveChange("%s property '%s' has been added for %s", AbstractPropertyTaskStateChanges.this.title, currentProperty, AbstractPropertyTaskStateChanges.this.task));
            }

            @Override
            public void updated(String property, V previous, V current) {
            }
        });
    }
}

