/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import java.util.ArrayList;
import java.util.Iterator;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.changedetection.rules.PropertyDiffListener;
import org.gradle.api.internal.changedetection.rules.SortedMapDiffUtil;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.Iterators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public abstract class AbstractNamedFileSnapshotTaskStateChanges
implements TaskStateChanges {
    protected final TaskExecution previous;
    protected final TaskExecution current;
    private final String title;

    protected AbstractNamedFileSnapshotTaskStateChanges(TaskExecution previous, TaskExecution current, String title) {
        this.previous = previous;
        this.current = current;
        this.title = title;
    }

    private ImmutableSortedMap<String, FileCollectionSnapshot> getPrevious() {
        return this.getSnapshot(this.previous);
    }

    private ImmutableSortedMap<String, FileCollectionSnapshot> getCurrent() {
        return this.getSnapshot(this.current);
    }

    protected abstract ImmutableSortedMap<String, FileCollectionSnapshot> getSnapshot(TaskExecution var1);

    protected Iterator<TaskStateChange> getFileChanges(final boolean includeAdded) {
        final ArrayList iterators = new ArrayList();
        SortedMapDiffUtil.diff(this.getPrevious(), this.getCurrent(), new PropertyDiffListener<String, FileCollectionSnapshot>(){

            @Override
            public void removed(String previousProperty) {
            }

            @Override
            public void added(String currentProperty) {
            }

            @Override
            public void updated(String property, FileCollectionSnapshot previousSnapshot, FileCollectionSnapshot currentSnapshot) {
                String propertyTitle = AbstractNamedFileSnapshotTaskStateChanges.this.title + " property '" + property + "'";
                iterators.add(currentSnapshot.iterateContentChangesSince(previousSnapshot, propertyTitle, includeAdded));
            }
        });
        return Iterators.concat(iterators.iterator());
    }
}

