/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.List;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformer;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.RunnableBuildOperation;

class TransformArtifactOperation
implements RunnableBuildOperation {
    private final ResolvableArtifact artifact;
    private final ArtifactTransformer transform;
    private Throwable failure;
    private List<File> result;

    TransformArtifactOperation(ResolvableArtifact artifact, ArtifactTransformer transform) {
        this.artifact = artifact;
        this.transform = transform;
    }

    @Override
    public void run(BuildOperationContext context) {
        try {
            this.result = this.transform.transform(this.artifact.getFile());
        }
        catch (Throwable t) {
            this.failure = t;
        }
    }

    @Override
    public BuildOperationDescriptor.Builder description() {
        return BuildOperationDescriptor.displayName("Apply " + this.transform.getDisplayName() + " to " + this.artifact);
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public List<File> getResult() {
        return this.result;
    }
}

