/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformer;

class ChainedTransformer
implements ArtifactTransformer {
    private final ArtifactTransformer first;
    private final ArtifactTransformer second;

    public ChainedTransformer(ArtifactTransformer first, ArtifactTransformer second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public List<File> transform(File file) {
        ArrayList<File> result = new ArrayList<File>();
        for (File intermediate : this.first.transform(file)) {
            result.addAll(this.second.transform(intermediate));
        }
        return result;
    }

    @Override
    public boolean hasCachedResult(File input) {
        if (this.first.hasCachedResult(input)) {
            for (File intermediate : this.first.transform(input)) {
                if (this.second.hasCachedResult(intermediate)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getDisplayName() {
        return this.first.getDisplayName() + " -> " + this.second.getDisplayName();
    }
}

