/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.InstantiatorFactory;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.ModuleMetadataParser;
import org.gradle.api.internal.artifacts.repositories.AbstractAuthenticationSupportedRepository;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.repositories.maven.MavenMetadataLoader;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultArtifactMetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultGradleModuleMetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultImmutableMetadataSources;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultMavenPomMetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.ImmutableMetadataSources;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenMetadataArtifactProvider;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenMutableModuleMetadataFactory;
import org.gradle.api.internal.artifacts.repositories.metadata.MetadataSource;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenResolver;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransportFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.MutableMavenModuleResolveMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;

public class DefaultMavenArtifactRepository
extends AbstractAuthenticationSupportedRepository
implements MavenArtifactRepository,
ResolutionAwareRepository,
PublicationAwareRepository {
    private static final DefaultMavenPomMetadataSource.MavenMetadataValidator NO_OP_VALIDATION_SERVICES = new DefaultMavenPomMetadataSource.MavenMetadataValidator(){

        @Override
        public boolean isUsableModule(String repoName, MutableMavenModuleResolveMetadata metadata, ExternalResourceArtifactResolver artifactResolver) {
            return true;
        }
    };
    private final Transformer<String, MavenArtifactRepository> describer;
    private final FileResolver fileResolver;
    private final RepositoryTransportFactory transportFactory;
    private Object url;
    private List<Object> additionalUrls = new ArrayList<Object>();
    private final LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder;
    private final FileStore<ModuleComponentArtifactIdentifier> artifactFileStore;
    private final MetaDataParser<MutableMavenModuleResolveMetadata> pomParser;
    private final ModuleMetadataParser metadataParser;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final FileStore<String> resourcesFileStore;
    private final FileResourceRepository fileResourceRepository;
    private final MavenMutableModuleMetadataFactory metadataFactory;
    private final MavenMetadataSources metadataSources = new MavenMetadataSources();

    public DefaultMavenArtifactRepository(FileResolver fileResolver, RepositoryTransportFactory transportFactory, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, InstantiatorFactory instantiatorFactory, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, MetaDataParser<MutableMavenModuleResolveMetadata> pomParser, ModuleMetadataParser metadataParser, AuthenticationContainer authenticationContainer, ImmutableModuleIdentifierFactory moduleIdentifierFactory, FileStore<String> resourcesFileStore, FileResourceRepository fileResourceRepository, FeaturePreviews featurePreviews, MavenMutableModuleMetadataFactory metadataFactory) {
        this(new DefaultDescriber(), fileResolver, transportFactory, locallyAvailableResourceFinder, instantiatorFactory, artifactFileStore, pomParser, metadataParser, authenticationContainer, moduleIdentifierFactory, resourcesFileStore, fileResourceRepository, featurePreviews, metadataFactory);
    }

    public DefaultMavenArtifactRepository(Transformer<String, MavenArtifactRepository> describer, FileResolver fileResolver, RepositoryTransportFactory transportFactory, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, InstantiatorFactory instantiatorFactory, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, MetaDataParser<MutableMavenModuleResolveMetadata> pomParser, ModuleMetadataParser metadataParser, AuthenticationContainer authenticationContainer, ImmutableModuleIdentifierFactory moduleIdentifierFactory, FileStore<String> resourcesFileStore, FileResourceRepository fileResourceRepository, FeaturePreviews featurePreviews, MavenMutableModuleMetadataFactory metadataFactory) {
        super(instantiatorFactory.decorate(), authenticationContainer);
        this.describer = describer;
        this.fileResolver = fileResolver;
        this.transportFactory = transportFactory;
        this.locallyAvailableResourceFinder = locallyAvailableResourceFinder;
        this.artifactFileStore = artifactFileStore;
        this.pomParser = pomParser;
        this.metadataParser = metadataParser;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.resourcesFileStore = resourcesFileStore;
        this.fileResourceRepository = fileResourceRepository;
        this.metadataFactory = metadataFactory;
        this.metadataSources.setDefaults(featurePreviews);
    }

    @Override
    public String getDisplayName() {
        return this.describer.transform(this);
    }

    @Override
    public URI getUrl() {
        return this.url == null ? null : this.fileResolver.resolveUri(this.url);
    }

    @Override
    public void setUrl(URI url) {
        this.url = url;
    }

    @Override
    public void setUrl(Object url) {
        this.url = url;
    }

    @Override
    public Set<URI> getArtifactUrls() {
        LinkedHashSet<URI> result = new LinkedHashSet<URI>();
        for (Object additionalUrl : this.additionalUrls) {
            result.add(this.fileResolver.resolveUri(additionalUrl));
        }
        return result;
    }

    @Override
    public void artifactUrls(Object ... urls) {
        this.additionalUrls.addAll(Lists.newArrayList((Object[])urls));
    }

    @Override
    public void setArtifactUrls(Set<URI> urls) {
        this.setArtifactUrls((Iterable<?>)urls);
    }

    @Override
    public void setArtifactUrls(Iterable<?> urls) {
        this.additionalUrls = Lists.newArrayList(urls);
    }

    @Override
    public ModuleVersionPublisher createPublisher() {
        return this.createRealResolver();
    }

    @Override
    public ConfiguredModuleComponentRepository createResolver() {
        return this.createRealResolver();
    }

    protected MavenResolver createRealResolver() {
        URI rootUri = this.getUrl();
        if (rootUri == null) {
            throw new InvalidUserDataException("You must specify a URL for a Maven repository.");
        }
        MavenResolver resolver = this.createResolver(rootUri);
        for (URI repoUrl : this.getArtifactUrls()) {
            resolver.addArtifactLocation(repoUrl);
        }
        return resolver;
    }

    private MavenResolver createResolver(URI rootUri) {
        RepositoryTransport transport = this.getTransport(rootUri.getScheme());
        MavenMetadataLoader mavenMetadataLoader = new MavenMetadataLoader(transport.getResourceAccessor(), this.resourcesFileStore);
        ImmutableMetadataSources metadataSources = this.createMetadataSources(mavenMetadataLoader);
        return new MavenResolver(this.getName(), rootUri, transport, this.locallyAvailableResourceFinder, this.artifactFileStore, this.moduleIdentifierFactory, metadataSources, MavenMetadataArtifactProvider.INSTANCE, mavenMetadataLoader);
    }

    @Override
    public void metadataSources(Action<? super MavenArtifactRepository.MetadataSources> configureAction) {
        this.metadataSources.reset();
        configureAction.execute(this.metadataSources);
    }

    ImmutableMetadataSources createMetadataSources(MavenMetadataLoader mavenMetadataLoader) {
        ImmutableList.Builder sources = ImmutableList.builder();
        if (this.metadataSources.gradleMetadata) {
            boolean listVersionsForGradleMetadata = !this.metadataSources.mavenPom;
            sources.add((Object)new DefaultGradleModuleMetadataSource(this.getMetadataParser(), this.metadataFactory, listVersionsForGradleMetadata));
        }
        if (this.metadataSources.mavenPom) {
            sources.add((Object)new DefaultMavenPomMetadataSource(MavenMetadataArtifactProvider.INSTANCE, this.getPomParser(), this.fileResourceRepository, this.getMetadataValidationServices(), mavenMetadataLoader));
        }
        if (this.metadataSources.artifact) {
            sources.add((Object)new DefaultArtifactMetadataSource(this.metadataFactory));
        }
        return new DefaultImmutableMetadataSources((Iterable<MetadataSource<?>>)sources.build());
    }

    protected DefaultMavenPomMetadataSource.MavenMetadataValidator getMetadataValidationServices() {
        return NO_OP_VALIDATION_SERVICES;
    }

    private MetaDataParser<MutableMavenModuleResolveMetadata> getPomParser() {
        return this.pomParser;
    }

    private ModuleMetadataParser getMetadataParser() {
        return this.metadataParser;
    }

    FileStore<ModuleComponentArtifactIdentifier> getArtifactFileStore() {
        return this.artifactFileStore;
    }

    FileStore<String> getResourcesFileStore() {
        return this.resourcesFileStore;
    }

    RepositoryTransport getTransport(String scheme) {
        return this.transportFactory.createTransport(scheme, this.getName(), this.getConfiguredAuthentication());
    }

    protected LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> getLocallyAvailableResourceFinder() {
        return this.locallyAvailableResourceFinder;
    }

    private static class MavenMetadataSources
    implements MavenArtifactRepository.MetadataSources {
        boolean gradleMetadata;
        boolean mavenPom;
        boolean artifact;

        private MavenMetadataSources() {
        }

        void setDefaults(FeaturePreviews featurePreviews) {
            this.mavenPom();
            if (featurePreviews.isFeatureEnabled(FeaturePreviews.Feature.GRADLE_METADATA)) {
                this.gradleMetadata();
            } else {
                this.artifact();
            }
        }

        void reset() {
            this.gradleMetadata = false;
            this.mavenPom = false;
            this.artifact = false;
        }

        @Override
        public void gradleMetadata() {
            this.gradleMetadata = true;
        }

        @Override
        public void mavenPom() {
            this.mavenPom = true;
        }

        @Override
        public void artifact() {
            this.artifact = true;
        }
    }

    private static class DefaultDescriber
    implements Transformer<String, MavenArtifactRepository> {
        private DefaultDescriber() {
        }

        @Override
        public String transform(MavenArtifactRepository repository) {
            URI url = repository.getUrl();
            if (url == null) {
                return repository.getName();
            }
            return repository.getName() + '(' + url + ')';
        }
    }
}

