/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.publish;

import java.io.File;
import java.util.Date;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.internal.artifacts.publish.AbstractPublishArtifact;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.util.GUtil;

public class ArchivePublishArtifact
extends AbstractPublishArtifact
implements ConfigurablePublishArtifact {
    private String name;
    private String extension;
    private String type;
    private String classifier;
    private Date date;
    private File file;
    private AbstractArchiveTask archiveTask;

    public ArchivePublishArtifact(AbstractArchiveTask archiveTask) {
        super(archiveTask);
        this.archiveTask = archiveTask;
    }

    public ArchivePublishArtifact builtBy(Object ... tasks) {
        super.builtBy(tasks);
        return this;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.archiveTask.getBaseName() != null) {
            return this.withAppendix(this.archiveTask.getBaseName());
        }
        return this.archiveTask.getAppendix();
    }

    private String withAppendix(String baseName) {
        return baseName + (GUtil.isTrue(this.archiveTask.getAppendix()) ? "-" + this.archiveTask.getAppendix() : "");
    }

    public String getExtension() {
        return GUtil.elvis(this.extension, this.archiveTask.getExtension());
    }

    public String getType() {
        return GUtil.elvis(this.type, this.archiveTask.getExtension());
    }

    public String getClassifier() {
        return GUtil.elvis(this.classifier, this.archiveTask.getClassifier());
    }

    public File getFile() {
        return GUtil.elvis(this.file, this.archiveTask.getArchivePath());
    }

    public Date getDate() {
        return GUtil.elvis(this.date, new Date(this.archiveTask.getArchivePath().lastModified()));
    }

    public AbstractArchiveTask getArchiveTask() {
        return this.archiveTask;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

