/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.CompositeVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.internal.impldep.com.google.common.collect.Iterators;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

abstract class MessageBuilderHelper {
    MessageBuilderHelper() {
    }

    static Collection<String> pathTo(EdgeState edge) {
        return MessageBuilderHelper.pathTo(edge, true);
    }

    static Collection<String> pathTo(EdgeState edge, boolean includeLast) {
        ArrayList acc = Lists.newArrayListWithExpectedSize((int)1);
        MessageBuilderHelper.pathTo(edge, Lists.newArrayList(), acc, Sets.newHashSet());
        ArrayList result = Lists.newArrayListWithCapacity((int)acc.size());
        for (List path : acc) {
            EdgeState target = (EdgeState)Iterators.getLast(path.iterator());
            StringBuilder sb = new StringBuilder();
            if (target.getSelector().getDependencyMetadata().isPending()) {
                sb.append("Constraint path ");
            } else {
                sb.append("Dependency path ");
            }
            boolean first = true;
            for (EdgeState e : path) {
                if (!first) {
                    sb.append(" --> ");
                }
                first = false;
                ModuleVersionIdentifier id = e.getFrom().getResolvedConfigurationId().getId();
                sb.append('\'').append(id).append('\'');
            }
            if (includeLast) {
                sb.append(" --> ");
                ModuleIdentifier moduleId = edge.getSelector().getTargetModule().getId();
                sb.append('\'').append(moduleId.getGroup()).append(':').append(moduleId.getName()).append('\'');
            }
            result.add(sb.toString());
        }
        return result;
    }

    static void pathTo(EdgeState component, List<EdgeState> currentPath, List<List<EdgeState>> accumulator, Set<NodeState> alreadySeen) {
        if (alreadySeen.add(component.getFrom())) {
            currentPath.add(0, component);
            for (EdgeState dependent : component.getFrom().getIncomingEdges()) {
                ArrayList otherPath = Lists.newArrayList(currentPath);
                MessageBuilderHelper.pathTo(dependent, otherPath, accumulator, alreadySeen);
            }
            if (component.getFrom().isRoot()) {
                accumulator.add(currentPath);
            }
        }
    }

    static String renderVersionConstraint(ResolvedVersionConstraint constraint) {
        if (constraint.isRejectAll()) {
            return "rejects all versions";
        }
        VersionSelector preferredSelector = constraint.getPreferredSelector();
        VersionSelector rejectedSelector = constraint.getRejectedSelector();
        StringBuilder sb = new StringBuilder("prefers ");
        sb.append('\'');
        sb.append(preferredSelector.getSelector());
        sb.append('\'');
        if (rejectedSelector != null) {
            sb.append(", rejects ");
            if (rejectedSelector instanceof CompositeVersionSelector) {
                sb.append("any of \"");
                int i = 0;
                for (VersionSelector selector : ((CompositeVersionSelector)rejectedSelector).getSelectors()) {
                    if (i++ > 0) {
                        sb.append(", ");
                    }
                    sb.append('\'');
                    sb.append(selector.getSelector());
                    sb.append('\'');
                }
                sb.append("\"");
            } else {
                sb.append('\'');
                sb.append(rejectedSelector.getSelector());
                sb.append('\'');
            }
        }
        return sb.toString();
    }
}

