/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.AbstractCompositeExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.AbstractModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ArtifactExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ExcludeAllModulesSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ExcludeNone;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.GroupNameExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ImmutableModuleExclusionSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.IntersectionExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.IvyPatternMatcherExcludeRuleSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleIdExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleNameExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.PatternMatchers;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.UnionExclusion;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

public class ModuleExclusions {
    private static final ExcludeNone EXCLUDE_NONE = new ExcludeNone();
    private static final ExcludeAllModulesSpec EXCLUDE_ALL_MODULES_SPEC = new ExcludeAllModulesSpec();
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final Map<MergeOperation, AbstractModuleExclusion> mergeCache = Maps.newConcurrentMap();
    private final Map<ImmutableList<ExcludeMetadata>, AbstractModuleExclusion> excludeAnyCache = Maps.newConcurrentMap();
    private final Map<ImmutableSet<AbstractModuleExclusion>, IntersectionExclusion> intersectionCache = Maps.newConcurrentMap();
    private final Map<AbstractModuleExclusion[], Map<AbstractModuleExclusion[], MergeOperation>> mergeOperationCache = Maps.newIdentityHashMap();
    private final Map<ModuleIdentifier, ModuleIdExcludeSpec> moduleIdSpecs = Maps.newConcurrentMap();
    private final Map<String, ModuleNameExcludeSpec> moduleNameSpecs = Maps.newConcurrentMap();
    private final Map<String, GroupNameExcludeSpec> groupNameSpecs = Maps.newConcurrentMap();
    private final Object mergeOperationLock = new Object();

    public ModuleExclusions(ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    public static ModuleExclusion excludeNone() {
        return EXCLUDE_NONE;
    }

    public ModuleExclusion excludeAny(ExcludeMetadata ... excludes) {
        if (excludes.length == 0) {
            return EXCLUDE_NONE;
        }
        return this.excludeAny((ImmutableList<ExcludeMetadata>)ImmutableList.copyOf((Object[])excludes));
    }

    public ModuleExclusion excludeAny(ImmutableList<ExcludeMetadata> excludes) {
        if (excludes.isEmpty()) {
            return EXCLUDE_NONE;
        }
        AbstractModuleExclusion exclusion = this.excludeAnyCache.get(excludes);
        if (exclusion != null) {
            return exclusion;
        }
        ImmutableSet.Builder exclusions = ImmutableSet.builder();
        for (ExcludeMetadata exclude : excludes) {
            exclusions.add((Object)this.forExclude(exclude));
        }
        exclusion = this.asIntersection((ImmutableSet<AbstractModuleExclusion>)exclusions.build());
        this.excludeAnyCache.put(excludes, exclusion);
        return exclusion;
    }

    private AbstractModuleExclusion forExclude(ExcludeMetadata rule) {
        if (!PatternMatchers.isExactMatcher(rule.getMatcher())) {
            return new IvyPatternMatcherExcludeRuleSpec(rule);
        }
        ModuleIdentifier moduleId = rule.getModuleId();
        IvyArtifactName artifact = rule.getArtifact();
        boolean anyOrganisation = AbstractModuleExclusion.isWildcard(moduleId.getGroup());
        boolean anyModule = AbstractModuleExclusion.isWildcard(moduleId.getName());
        if (artifact == null) {
            if (!anyOrganisation && !anyModule) {
                return this.moduleIdExcludeSpec(moduleId);
            }
            if (!anyModule) {
                return this.moduleNameExcludeSpec(moduleId.getName());
            }
            if (!anyOrganisation) {
                return this.groupNameExcludeSpec(moduleId.getGroup());
            }
            return EXCLUDE_ALL_MODULES_SPEC;
        }
        return new ArtifactExcludeSpec(moduleId, artifact);
    }

    private ModuleIdExcludeSpec moduleIdExcludeSpec(ModuleIdentifier id) {
        ModuleIdExcludeSpec spec = this.moduleIdSpecs.get(id);
        if (spec == null) {
            spec = new ModuleIdExcludeSpec(id);
            this.moduleIdSpecs.put(id, spec);
        }
        return spec;
    }

    private ModuleNameExcludeSpec moduleNameExcludeSpec(String id) {
        ModuleNameExcludeSpec spec = this.moduleNameSpecs.get(id);
        if (spec == null) {
            spec = new ModuleNameExcludeSpec(id);
            this.moduleNameSpecs.put(id, spec);
        }
        return spec;
    }

    private GroupNameExcludeSpec groupNameExcludeSpec(String id) {
        GroupNameExcludeSpec spec = this.groupNameSpecs.get(id);
        if (spec == null) {
            spec = new GroupNameExcludeSpec(id);
            this.groupNameSpecs.put(id, spec);
        }
        return spec;
    }

    public ModuleExclusion intersect(ModuleExclusion one, ModuleExclusion two) {
        if (one == two) {
            return one;
        }
        if (one == EXCLUDE_NONE) {
            return two;
        }
        if (two == EXCLUDE_NONE) {
            return one;
        }
        if (one.equals(two)) {
            return one;
        }
        if (one instanceof IntersectionExclusion && ((IntersectionExclusion)one).getFilters().contains(two)) {
            return one;
        }
        if (two instanceof IntersectionExclusion && ((IntersectionExclusion)two).getFilters().contains(one)) {
            return two;
        }
        AbstractModuleExclusion aOne = (AbstractModuleExclusion)one;
        AbstractModuleExclusion aTwo = (AbstractModuleExclusion)two;
        ArrayList builder = Lists.newArrayListWithExpectedSize((int)(ModuleExclusions.estimateSize(aOne) + ModuleExclusions.estimateSize(aTwo)));
        aOne.unpackIntersection(builder);
        aTwo.unpackIntersection(builder);
        return this.asIntersection((ImmutableSet<AbstractModuleExclusion>)ImmutableSet.copyOf((Collection)builder));
    }

    private static int estimateSize(AbstractModuleExclusion ex) {
        if (ex instanceof AbstractCompositeExclusion) {
            return ((AbstractCompositeExclusion)ex).getFilters().size();
        }
        return 1;
    }

    public ModuleExclusion union(ModuleExclusion one, ModuleExclusion two) {
        if (one == two) {
            return one;
        }
        if (one == EXCLUDE_NONE || two == EXCLUDE_NONE) {
            return EXCLUDE_NONE;
        }
        if (one.equals(two)) {
            return one;
        }
        ArrayList<AbstractModuleExclusion> specs = new ArrayList<AbstractModuleExclusion>();
        ((AbstractModuleExclusion)one).unpackUnion(specs);
        ((AbstractModuleExclusion)two).unpackUnion(specs);
        int i = 0;
        while (i < specs.size()) {
            AbstractModuleExclusion spec = (AbstractModuleExclusion)specs.get(i);
            AbstractModuleExclusion merged = null;
            for (int j = i + 1; j < specs.size(); ++j) {
                AbstractModuleExclusion other = (AbstractModuleExclusion)specs.get(j);
                merged = this.maybeMergeIntoUnion(spec, other);
                if (merged == null) continue;
                specs.remove(j);
                break;
            }
            if (merged != null) {
                specs.set(i, merged);
                continue;
            }
            ++i;
        }
        if (specs.size() == 1) {
            return (ModuleExclusion)specs.get(0);
        }
        return new UnionExclusion(specs);
    }

    private AbstractModuleExclusion maybeMergeIntoUnion(AbstractModuleExclusion one, AbstractModuleExclusion two) {
        if (one.equals(two)) {
            return one;
        }
        if (one instanceof IntersectionExclusion && two instanceof IntersectionExclusion) {
            return this.maybeMergeIntoUnion((IntersectionExclusion)one, (IntersectionExclusion)two);
        }
        return null;
    }

    private AbstractModuleExclusion maybeMergeIntoUnion(IntersectionExclusion one, IntersectionExclusion other) {
        if (one.equals(other)) {
            return one;
        }
        if (one.canMerge() && other.canMerge()) {
            Object[] oneFilters = one.getFilters().elements;
            Object[] otherFilters = other.getFilters().elements;
            if (Arrays.equals(oneFilters, otherFilters)) {
                return one;
            }
            MergeOperation merge = this.mergeOperation((AbstractModuleExclusion[])oneFilters, (AbstractModuleExclusion[])otherFilters);
            AbstractModuleExclusion exclusion = this.mergeCache.get(merge);
            if (exclusion != null) {
                return exclusion;
            }
            return this.mergeAndCacheResult(merge, (AbstractModuleExclusion[])oneFilters, (AbstractModuleExclusion[])otherFilters);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MergeOperation mergeOperation(AbstractModuleExclusion[] one, AbstractModuleExclusion[] two) {
        Object object = this.mergeOperationLock;
        synchronized (object) {
            MergeOperation mergeOperation;
            IdentityHashMap oneMap = this.mergeOperationCache.get(one);
            if (oneMap == null) {
                oneMap = Maps.newIdentityHashMap();
                this.mergeOperationCache.put(one, oneMap);
            }
            if ((mergeOperation = (MergeOperation)oneMap.get(two)) != null) {
                return mergeOperation;
            }
            mergeOperation = new MergeOperation(one, two);
            oneMap.put(two, mergeOperation);
            return mergeOperation;
        }
    }

    private AbstractModuleExclusion mergeAndCacheResult(MergeOperation merge, AbstractModuleExclusion[] oneFilters, AbstractModuleExclusion[] otherFilters) {
        BitSet remaining = new BitSet(otherFilters.length);
        remaining.set(0, otherFilters.length, true);
        MergeSet merged = new MergeSet(remaining, oneFilters.length + otherFilters.length);
        for (AbstractModuleExclusion thisSpec : oneFilters) {
            if (remaining.isEmpty()) continue;
            int i = remaining.nextSetBit(0);
            while (i >= 0) {
                AbstractModuleExclusion otherSpec = otherFilters[i];
                merged.current = otherSpec;
                merged.idx = i;
                this.mergeExcludeRules(thisSpec, otherSpec, (Set<AbstractModuleExclusion>)merged);
                i = remaining.nextSetBit(i + 1);
            }
        }
        AbstractModuleExclusion exclusion = merged.isEmpty() ? EXCLUDE_NONE : this.asIntersection((ImmutableSet<AbstractModuleExclusion>)ImmutableSet.copyOf((Collection)merged));
        this.mergeCache.put(merge, exclusion);
        return exclusion;
    }

    private IntersectionExclusion asIntersection(ImmutableSet<AbstractModuleExclusion> excludes) {
        IntersectionExclusion cached = this.intersectionCache.get(excludes);
        if (cached == null) {
            cached = new IntersectionExclusion(new ImmutableModuleExclusionSet(excludes));
            this.intersectionCache.put(excludes, cached);
        }
        return cached;
    }

    private void mergeExcludeRules(AbstractModuleExclusion spec1, AbstractModuleExclusion spec2, Set<AbstractModuleExclusion> merged) {
        if (spec1 == spec2) {
            merged.add(spec1);
        } else if (spec1 instanceof ExcludeAllModulesSpec) {
            merged.add(spec2);
        } else if (spec2 instanceof ExcludeAllModulesSpec) {
            merged.add(spec1);
        } else if (spec1 instanceof ArtifactExcludeSpec) {
            merged.add(spec1);
        } else if (spec2 instanceof ArtifactExcludeSpec) {
            merged.add(spec2);
        } else if (spec1 instanceof GroupNameExcludeSpec) {
            this.mergeExcludeRules((GroupNameExcludeSpec)spec1, spec2, merged);
        } else if (spec2 instanceof GroupNameExcludeSpec) {
            this.mergeExcludeRules((GroupNameExcludeSpec)spec2, spec1, merged);
        } else if (spec1 instanceof ModuleNameExcludeSpec) {
            ModuleExclusions.mergeExcludeRules((ModuleNameExcludeSpec)spec1, spec2, merged);
        } else if (spec2 instanceof ModuleNameExcludeSpec) {
            ModuleExclusions.mergeExcludeRules((ModuleNameExcludeSpec)spec2, spec1, merged);
        } else if (spec1 instanceof ModuleIdExcludeSpec && spec2 instanceof ModuleIdExcludeSpec) {
            ModuleIdExcludeSpec moduleSpec1 = (ModuleIdExcludeSpec)spec1;
            ModuleIdExcludeSpec moduleSpec2 = (ModuleIdExcludeSpec)spec2;
            if (moduleSpec1.moduleId.equals(moduleSpec2.moduleId)) {
                merged.add(moduleSpec1);
            }
        } else {
            throw new UnsupportedOperationException(String.format("Cannot calculate intersection of exclude rules: %s, %s", spec1, spec2));
        }
    }

    private void mergeExcludeRules(GroupNameExcludeSpec spec1, AbstractModuleExclusion spec2, Set<AbstractModuleExclusion> merged) {
        if (spec2 instanceof GroupNameExcludeSpec) {
            GroupNameExcludeSpec groupNameExcludeSpec = (GroupNameExcludeSpec)spec2;
            if (spec1.group.equals(groupNameExcludeSpec.group)) {
                merged.add(spec1);
            }
        } else if (spec2 instanceof ModuleNameExcludeSpec) {
            ModuleNameExcludeSpec moduleNameExcludeSpec = (ModuleNameExcludeSpec)spec2;
            merged.add(this.moduleIdExcludeSpec(this.moduleIdentifierFactory.module(spec1.group, moduleNameExcludeSpec.module)));
        } else if (spec2 instanceof ModuleIdExcludeSpec) {
            ModuleIdExcludeSpec moduleIdExcludeSpec = (ModuleIdExcludeSpec)spec2;
            if (moduleIdExcludeSpec.moduleId.getGroup().equals(spec1.group)) {
                merged.add(spec2);
            }
        } else {
            throw new UnsupportedOperationException(String.format("Cannot calculate intersection of exclude rules: %s, %s", spec1, spec2));
        }
    }

    private static void mergeExcludeRules(ModuleNameExcludeSpec spec1, AbstractModuleExclusion spec2, Set<AbstractModuleExclusion> merged) {
        if (spec2 instanceof ModuleNameExcludeSpec) {
            ModuleNameExcludeSpec moduleNameExcludeSpec = (ModuleNameExcludeSpec)spec2;
            if (spec1.module.equals(moduleNameExcludeSpec.module)) {
                merged.add(spec1);
            }
        } else if (spec2 instanceof ModuleIdExcludeSpec) {
            ModuleIdExcludeSpec moduleIdExcludeSpec = (ModuleIdExcludeSpec)spec2;
            if (moduleIdExcludeSpec.moduleId.getName().equals(spec1.module)) {
                merged.add(spec2);
            }
        } else {
            throw new UnsupportedOperationException(String.format("Cannot calculate intersection of exclude rules: %s, %s", spec1, spec2));
        }
    }

    private static final class MergeSet
    extends HashSet<AbstractModuleExclusion> {
        private final BitSet remaining;
        private int idx;
        private AbstractModuleExclusion current;

        private MergeSet(BitSet remaining, int size) {
            super(size);
            this.remaining = remaining;
        }

        @Override
        public boolean add(AbstractModuleExclusion abstractModuleExclusion) {
            if (this.current == abstractModuleExclusion) {
                this.remaining.clear(this.idx);
            }
            return super.add(abstractModuleExclusion);
        }
    }

    private static final class MergeOperation {
        private final AbstractModuleExclusion[] one;
        private final AbstractModuleExclusion[] two;
        private final int hashCode;

        private MergeOperation(AbstractModuleExclusion[] one, AbstractModuleExclusion[] two) {
            this.one = one;
            this.two = two;
            this.hashCode = 31 * Arrays.hashCode(one) + Arrays.hashCode(two);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MergeOperation that = (MergeOperation)o;
            return Arrays.equals(this.one, that.one) && Arrays.equals(this.two, that.two);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

