/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts;

import java.math.BigInteger;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.CacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ArtifactsAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.InMemoryModuleArtifactsCache;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactMetadataSerializer;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SetSerializer;
import org.gradle.util.BuildCommencedTimeProvider;

public class DefaultModuleArtifactsCache
extends InMemoryModuleArtifactsCache {
    private final CacheLockingManager cacheLockingManager;
    private PersistentIndexedCache<ArtifactsAtRepositoryKey, InMemoryModuleArtifactsCache.ModuleArtifactsCacheEntry> cache;

    public DefaultModuleArtifactsCache(BuildCommencedTimeProvider timeProvider, CacheLockingManager cacheLockingManager) {
        super(timeProvider);
        this.cacheLockingManager = cacheLockingManager;
    }

    private PersistentIndexedCache<ArtifactsAtRepositoryKey, InMemoryModuleArtifactsCache.ModuleArtifactsCacheEntry> getCache() {
        if (this.cache == null) {
            this.cache = this.initCache();
        }
        return this.cache;
    }

    private PersistentIndexedCache<ArtifactsAtRepositoryKey, InMemoryModuleArtifactsCache.ModuleArtifactsCacheEntry> initCache() {
        return this.cacheLockingManager.createCache("module-artifacts", new ModuleArtifactsKeySerializer(), new ModuleArtifactsCacheEntrySerializer());
    }

    @Override
    protected void store(ArtifactsAtRepositoryKey key, InMemoryModuleArtifactsCache.ModuleArtifactsCacheEntry entry) {
        super.store(key, entry);
        this.getCache().put(key, entry);
    }

    @Override
    protected InMemoryModuleArtifactsCache.ModuleArtifactsCacheEntry get(ArtifactsAtRepositoryKey key) {
        InMemoryModuleArtifactsCache.ModuleArtifactsCacheEntry entry = super.get(key);
        if (entry == null && (entry = this.getCache().get(key)) != null) {
            super.store(key, entry);
        }
        return entry;
    }

    private static class ModuleArtifactsCacheEntrySerializer
    extends AbstractSerializer<InMemoryModuleArtifactsCache.ModuleArtifactsCacheEntry> {
        private final Serializer<Set<ComponentArtifactMetadata>> artifactsSerializer = new SetSerializer<ComponentArtifactMetadata>(new ComponentArtifactMetadataSerializer());

        private ModuleArtifactsCacheEntrySerializer() {
        }

        @Override
        public void write(Encoder encoder, InMemoryModuleArtifactsCache.ModuleArtifactsCacheEntry value) throws Exception {
            encoder.writeLong(value.createTimestamp);
            byte[] hash = value.moduleDescriptorHash.toByteArray();
            encoder.writeBinary(hash);
            this.artifactsSerializer.write(encoder, value.artifacts);
        }

        @Override
        public InMemoryModuleArtifactsCache.ModuleArtifactsCacheEntry read(Decoder decoder) throws Exception {
            long createTimestamp = decoder.readLong();
            byte[] encodedHash = decoder.readBinary();
            BigInteger hash = new BigInteger(encodedHash);
            Set<ComponentArtifactMetadata> artifacts = this.artifactsSerializer.read(decoder);
            return new InMemoryModuleArtifactsCache.ModuleArtifactsCacheEntry(artifacts, createTimestamp, hash);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            ModuleArtifactsCacheEntrySerializer rhs = (ModuleArtifactsCacheEntrySerializer)obj;
            return Objects.equal(this.artifactsSerializer, rhs.artifactsSerializer);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.artifactsSerializer});
        }
    }

    private static class ModuleArtifactsKeySerializer
    extends AbstractSerializer<ArtifactsAtRepositoryKey> {
        private final ComponentIdentifierSerializer identifierSerializer = new ComponentIdentifierSerializer();

        private ModuleArtifactsKeySerializer() {
        }

        @Override
        public void write(Encoder encoder, ArtifactsAtRepositoryKey value) throws Exception {
            encoder.writeString(value.repositoryId);
            this.identifierSerializer.write(encoder, value.componentId);
            encoder.writeString(value.context);
        }

        @Override
        public ArtifactsAtRepositoryKey read(Decoder decoder) throws Exception {
            String resolverId = decoder.readString();
            ComponentIdentifier componentId = this.identifierSerializer.read(decoder);
            String context = decoder.readString();
            return new ArtifactsAtRepositoryKey(resolverId, componentId, context);
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            ModuleArtifactsKeySerializer rhs = (ModuleArtifactsKeySerializer)obj;
            return Objects.equal((Object)this.identifierSerializer, (Object)rhs.identifierSerializer);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.identifierSerializer});
        }
    }
}

