/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MavenVersionUtils;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.PomReader;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.data.PomDependencyMgt;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.descriptor.DefaultExclude;
import org.gradle.internal.component.external.descriptor.MavenScope;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.MavenDependencyDescriptor;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class GradlePomModuleDescriptorBuilder {
    public static final ImmutableMap<String, Configuration> MAVEN2_CONFIGURATIONS = ImmutableMap.builder().put((Object)"default", (Object)new Configuration("default", true, true, (Collection<String>)ImmutableSet.of((Object)"runtime", (Object)"master"))).put((Object)"master", (Object)new Configuration("master", true, true, (Collection<String>)ImmutableSet.of())).put((Object)"compile", (Object)new Configuration("compile", true, true, (Collection<String>)ImmutableSet.of())).put((Object)"provided", (Object)new Configuration("provided", true, true, (Collection<String>)ImmutableSet.of())).put((Object)"runtime", (Object)new Configuration("runtime", true, true, (Collection<String>)ImmutableSet.of((Object)"compile"))).put((Object)"test", (Object)new Configuration("test", true, false, (Collection<String>)ImmutableSet.of((Object)"runtime"))).put((Object)"system", (Object)new Configuration("system", true, true, (Collection<String>)ImmutableSet.of())).put((Object)"sources", (Object)new Configuration("sources", true, true, (Collection<String>)ImmutableSet.of())).put((Object)"javadoc", (Object)new Configuration("javadoc", true, true, (Collection<String>)ImmutableSet.of())).put((Object)"optional", (Object)new Configuration("optional", true, true, (Collection<String>)ImmutableSet.of())).build();
    private static final Map<String, MavenScope> SCOPES = ImmutableMap.builder().put((Object)"compile", (Object)MavenScope.Compile).put((Object)"runtime", (Object)MavenScope.Runtime).put((Object)"provided", (Object)MavenScope.Provided).put((Object)"test", (Object)MavenScope.Test).put((Object)"system", (Object)MavenScope.System).build();
    private final VersionSelectorScheme defaultVersionSelectorScheme;
    private final VersionSelectorScheme mavenVersionSelectorScheme;
    private List<MavenDependencyDescriptor> dependencies = Lists.newArrayList();
    private final PomReader pomReader;
    private String status;
    private ModuleComponentIdentifier componentIdentifier;

    public GradlePomModuleDescriptorBuilder(PomReader pomReader, VersionSelectorScheme gradleVersionSelectorScheme, VersionSelectorScheme mavenVersionSelectorScheme) {
        this.defaultVersionSelectorScheme = gradleVersionSelectorScheme;
        this.mavenVersionSelectorScheme = mavenVersionSelectorScheme;
        this.pomReader = pomReader;
    }

    public List<MavenDependencyDescriptor> getDependencies() {
        return this.dependencies;
    }

    public String getStatus() {
        return this.status;
    }

    public ModuleComponentIdentifier getComponentIdentifier() {
        return this.componentIdentifier;
    }

    public void setModuleRevId(String group, String module, String version) {
        String effectiveVersion = MavenVersionUtils.toEffectiveVersion(version);
        this.status = MavenVersionUtils.inferStatusFromEffectiveVersion(version);
        this.componentIdentifier = DefaultModuleComponentIdentifier.newId(group, module, effectiveVersion);
    }

    public void addDependency(PomReader.PomDependencyData dep) {
        this.doAddDependency(dep, dep.isOptional(), false);
    }

    public void addOptionalDependency(PomDependencyMgt dep) {
        this.doAddDependency(dep, true, true);
    }

    private void doAddDependency(PomDependencyMgt dep, boolean optional, boolean useCompileScope) {
        boolean hasNonJarType;
        MavenScope scope;
        if (useCompileScope) {
            scope = MavenScope.Compile;
        } else {
            String scopeString = dep.getScope();
            if (scopeString == null || scopeString.length() == 0) {
                scopeString = this.getDefaultScope(dep);
            }
            scope = SCOPES.containsKey(scopeString) ? SCOPES.get(scopeString) : MavenScope.Compile;
        }
        String version = this.determineVersion(dep);
        String mappedVersion = this.convertVersionFromMavenSyntax(version);
        ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(dep.getGroupId(), dep.getArtifactId(), new DefaultImmutableVersionConstraint(mappedVersion));
        if (selector.getGroup().equals(this.componentIdentifier.getGroup()) && selector.getModule().equals(this.componentIdentifier.getModule())) {
            return;
        }
        DefaultIvyArtifactName dependencyArtifact = null;
        boolean hasClassifier = dep.getClassifier() != null && dep.getClassifier().length() > 0;
        boolean bl = hasNonJarType = dep.getType() != null && !"jar".equals(dep.getType());
        if (hasClassifier || hasNonJarType) {
            String type = "jar";
            if (dep.getType() != null) {
                type = dep.getType();
            }
            String ext = this.determineExtension(type);
            String classifier = hasClassifier ? dep.getClassifier() : this.getClassifierForType(type);
            dependencyArtifact = new DefaultIvyArtifactName(selector.getModule(), type, ext, classifier);
        }
        ArrayList excludes = Lists.newArrayList();
        List<ModuleIdentifier> excluded = dep.getExcludedModules();
        if (excluded.isEmpty()) {
            excluded = this.getDependencyMgtExclusions(dep);
        }
        for (ModuleIdentifier excludedModule : excluded) {
            DefaultExclude rule = new DefaultExclude(excludedModule);
            excludes.add(rule);
        }
        this.dependencies.add(new MavenDependencyDescriptor(scope, optional, selector, dependencyArtifact, excludes));
    }

    private String convertVersionFromMavenSyntax(String version) {
        VersionSelector versionSelector = this.mavenVersionSelectorScheme.parseSelector(version);
        return this.defaultVersionSelectorScheme.renderSelector(versionSelector);
    }

    private String determineExtension(String type) {
        return JarDependencyType.isJarExtension(type) ? "jar" : type;
    }

    private String getClassifierForType(String type) {
        if (JarDependencyType.TEST_JAR.getName().equals(type)) {
            return "tests";
        }
        if (JarDependencyType.EJB_CLIENT.getName().equals(type)) {
            return "client";
        }
        return null;
    }

    private String determineVersion(PomDependencyMgt dependency) {
        String version = dependency.getVersion();
        version = version == null || version.length() == 0 ? this.getDefaultVersion(dependency) : version;
        return version == null ? "" : version;
    }

    public void addDependencyForRelocation(ModuleComponentSelector selector) {
        if (selector.getGroup().equals(this.componentIdentifier.getGroup()) && selector.getModule().equals(this.componentIdentifier.getModule())) {
            return;
        }
        this.dependencies.add(new MavenDependencyDescriptor(MavenScope.Runtime, false, selector, null, (List<ExcludeMetadata>)ImmutableList.of()));
    }

    private String getDefaultVersion(PomDependencyMgt dep) {
        PomDependencyMgt pomDependencyMgt = this.findDependencyDefault(dep);
        if (pomDependencyMgt != null) {
            return pomDependencyMgt.getVersion();
        }
        return null;
    }

    private String getDefaultScope(PomDependencyMgt dep) {
        PomDependencyMgt pomDependencyMgt = this.findDependencyDefault(dep);
        String result = null;
        if (pomDependencyMgt != null) {
            result = pomDependencyMgt.getScope();
        }
        if (result == null || !SCOPES.containsKey(result)) {
            result = "compile";
        }
        return result;
    }

    private List<ModuleIdentifier> getDependencyMgtExclusions(PomDependencyMgt dep) {
        PomDependencyMgt pomDependencyMgt = this.findDependencyDefault(dep);
        if (pomDependencyMgt != null) {
            return pomDependencyMgt.getExcludedModules();
        }
        return Collections.emptyList();
    }

    private PomDependencyMgt findDependencyDefault(PomDependencyMgt dependency) {
        return this.pomReader.findDependencyDefaults(dependency.getId());
    }

    private static enum JarDependencyType {
        TEST_JAR("test-jar"),
        EJB_CLIENT("ejb-client"),
        EJB("ejb"),
        BUNDLE("bundle"),
        MAVEN_PLUGIN("maven-plugin"),
        ECLIPSE_PLUGIN("eclipse-plugin");

        private static final Map<String, JarDependencyType> TYPES;
        private final String name;

        private JarDependencyType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static boolean isJarExtension(String type) {
            return TYPES.containsKey(type);
        }

        static {
            TYPES = new HashMap<String, JarDependencyType>();
            for (JarDependencyType type : JarDependencyType.values()) {
                TYPES.put(type.name, type);
            }
        }
    }
}

