/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import java.io.File;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.DescriptorParseContext;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParseException;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.hash.HashUtil;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;

public abstract class AbstractModuleDescriptorParser<T extends MutableModuleComponentResolveMetadata>
implements MetaDataParser<T> {
    private final FileResourceRepository fileResourceRepository;

    public AbstractModuleDescriptorParser(FileResourceRepository fileResourceRepository) {
        this.fileResourceRepository = fileResourceRepository;
    }

    @Override
    public T parseMetaData(DescriptorParseContext ivySettings, File descriptorFile, boolean validate) throws MetaDataParseException {
        LocallyAvailableExternalResource resource = this.fileResourceRepository.resource(descriptorFile);
        return this.parseDescriptor(ivySettings, resource, validate);
    }

    @Override
    public T parseMetaData(DescriptorParseContext ivySettings, File descriptorFile) throws MetaDataParseException {
        return this.parseMetaData(ivySettings, descriptorFile, false);
    }

    @Override
    public T parseMetaData(DescriptorParseContext ivySettings, LocallyAvailableExternalResource resource) throws MetaDataParseException {
        return this.parseDescriptor(ivySettings, resource, false);
    }

    protected T parseDescriptor(DescriptorParseContext ivySettings, LocallyAvailableExternalResource resource, boolean validate) throws MetaDataParseException {
        try {
            T metadata = this.doParseDescriptor(ivySettings, resource, validate);
            metadata.setContentHash(HashUtil.createHash(resource.getFile(), "MD5"));
            return metadata;
        }
        catch (MetaDataParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MetaDataParseException(this.getTypeName(), resource, e);
        }
    }

    protected abstract String getTypeName();

    protected abstract T doParseDescriptor(DescriptorParseContext var1, LocallyAvailableExternalResource var2, boolean var3) throws Exception;
}

