/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.io.File;
import java.util.Date;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.artifacts.dsl.ArtifactFile;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskDependency;

public class LazyPublishArtifact
implements PublishArtifact {
    private final Provider<?> provider;
    private final String version;
    private File file;
    private ArtifactFile artifactFile;

    public LazyPublishArtifact(Provider<?> provider, String version) {
        this.provider = provider;
        this.version = version;
    }

    @Override
    public String getName() {
        return this.getValue().getName();
    }

    @Override
    public String getExtension() {
        return this.getValue().getExtension();
    }

    @Override
    public String getType() {
        return "";
    }

    @Override
    public String getClassifier() {
        return this.getValue().getClassifier();
    }

    @Override
    public File getFile() {
        if (this.file == null) {
            Object value = this.provider.get();
            if (value instanceof FileSystemLocation) {
                FileSystemLocation location = (FileSystemLocation)value;
                this.file = location.getAsFile();
            } else if (value instanceof File) {
                this.file = (File)value;
            } else {
                throw new InvalidUserDataException(String.format("Cannot convert provided value (%s) to a file.", value));
            }
        }
        return this.file;
    }

    @Override
    public Date getDate() {
        return new Date();
    }

    private ArtifactFile getValue() {
        if (this.artifactFile == null) {
            this.artifactFile = new ArtifactFile(this.getFile(), this.version);
        }
        return this.artifactFile;
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return new AbstractTaskDependency(){

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                if (LazyPublishArtifact.this.provider instanceof TaskDependencyContainer) {
                    context.add(LazyPublishArtifact.this.provider);
                }
            }
        };
    }
}

